/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.bin;

import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import jnr.unixsocket.UnixSocket;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.bin.EmbeddedDBusDaemon;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.impl.DirectConnection;
import org.freedesktop.dbus.connections.transports.TransportFactory;
import org.freedesktop.dbus.errors.AccessDenied;
import org.freedesktop.dbus.errors.Error;
import org.freedesktop.dbus.errors.MatchRuleInvalid;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBus;
import org.freedesktop.dbus.interfaces.FatalException;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.interfaces.Peer;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.messages.MethodReturn;
import org.freedesktop.dbus.spi.InputStreamMessageReader;
import org.freedesktop.dbus.spi.OutputStreamMessageWriter;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.dbus.utils.Hexdump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DBusDaemon
extends Thread
implements Closeable {
    public static final int QUEUE_POLL_WAIT = 500;
    private static final Logger LOGGER = LoggerFactory.getLogger(DBusDaemon.class);
    private Map<Connstruct, Reader> conns = new HashMap<Connstruct, Reader>();
    private HashMap<String, Connstruct> names = new HashMap();
    private MagicMap<Message, WeakReference<Connstruct>> outqueue = new MagicMap("out");
    private MagicMap<Message, WeakReference<Connstruct>> inqueue = new MagicMap("in");
    private MagicMap<Message, WeakReference<Connstruct>> localqueue = new MagicMap("local");
    private List<Connstruct> sigrecips = new ArrayList<Connstruct>();
    private final AtomicBoolean run = new AtomicBoolean(true);
    private int nextUnique = 0;
    private Object uniqueLock = new Object();
    DBusServer dbusServer = new DBusServer();
    Sender sender = new Sender();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBusDaemon() {
        this.setName("Daemon");
        HashMap<String, Connstruct> hashMap = this.names;
        synchronized (hashMap) {
            this.names.put("org.freedesktop.DBus", null);
        }
    }

    private void send(Connstruct c, Message m) {
        this.send(c, m, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Connstruct c, Message m, boolean head) {
        LOGGER.debug("enter");
        if (null == c) {
            LOGGER.trace("Queing message {} for all connections", (Object)m);
        } else {
            LOGGER.trace("Queing message {} for {}", (Object)m, (Object)c.unique);
        }
        if (null == c) {
            Map<Connstruct, Reader> map = this.conns;
            synchronized (map) {
                MagicMap<Message, WeakReference<Connstruct>> magicMap = this.outqueue;
                synchronized (magicMap) {
                    for (Connstruct d : this.conns.keySet()) {
                        if (head) {
                            this.outqueue.putFirst(m, new WeakReference<Connstruct>(d));
                            continue;
                        }
                        this.outqueue.putLast(m, new WeakReference<Connstruct>(d));
                    }
                    this.outqueue.notifyAll();
                }
            }
        }
        MagicMap<Message, WeakReference<Connstruct>> magicMap = this.outqueue;
        synchronized (magicMap) {
            if (head) {
                this.outqueue.putFirst(m, new WeakReference<Connstruct>(c));
            } else {
                this.outqueue.putLast(m, new WeakReference<Connstruct>(c));
            }
            this.outqueue.notifyAll();
        }
        LOGGER.debug("exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Connstruct> findSignalMatches(DBusSignal sig) {
        ArrayList<Connstruct> l;
        LOGGER.debug("enter");
        List<Connstruct> list = this.sigrecips;
        synchronized (list) {
            l = new ArrayList<Connstruct>(this.sigrecips);
        }
        LOGGER.debug("exit");
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOGGER.debug("enter");
        while (this.isRunning()) {
            try {
                List<WeakReference<Connstruct>> wcs;
                Message m;
                MagicMap<Message, WeakReference<Connstruct>> magicMap = this.inqueue;
                synchronized (magicMap) {
                    while (0 == this.inqueue.size()) {
                        try {
                            this.inqueue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    m = this.inqueue.head();
                    wcs = this.inqueue.remove(m);
                }
                if (null == wcs) continue;
                for (WeakReference weakReference : wcs) {
                    Connstruct c = (Connstruct)weakReference.get();
                    if (null == c) continue;
                    LOGGER.info("<inqueue> Got message {} from {}", (Object)m, (Object)c.unique);
                    if (!(null != c.unique || m instanceof MethodCall && "org.freedesktop.DBus".equals(m.getDestination()) && "Hello".equals(m.getName()))) {
                        this.send(c, new Error("org.freedesktop.DBus", null, "org.freedesktop.DBus.Error.AccessDenied", m.getSerial(), "s", "You must send a Hello message"));
                        continue;
                    }
                    try {
                        if (null != c.unique) {
                            m.setSource(c.unique);
                        }
                    }
                    catch (DBusException dbe) {
                        LOGGER.debug("", (Throwable)dbe);
                        this.send(c, new Error("org.freedesktop.DBus", null, "org.freedesktop.DBus.Error.GeneralError", m.getSerial(), "s", "Sending message failed"));
                    }
                    if ("org.freedesktop.DBus".equals(m.getDestination())) {
                        MagicMap<Message, WeakReference<Connstruct>> dbe = this.localqueue;
                        synchronized (dbe) {
                            this.localqueue.putLast(m, weakReference);
                            this.localqueue.notifyAll();
                            continue;
                        }
                    }
                    if (m instanceof DBusSignal) {
                        List<Connstruct> list = this.findSignalMatches((DBusSignal)m);
                        for (Connstruct d : list) {
                            this.send(d, m);
                        }
                        continue;
                    }
                    Connstruct dest = this.names.get(m.getDestination());
                    if (null == dest) {
                        this.send(c, new Error("org.freedesktop.DBus", null, "org.freedesktop.DBus.Error.ServiceUnknown", m.getSerial(), "s", String.format("The name `%s' does not exist", m.getDestination())));
                        continue;
                    }
                    this.send(dest, m);
                }
            }
            catch (DBusException dbe) {
                LOGGER.debug("", (Throwable)dbe);
            }
        }
        LOGGER.debug("exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnection(Connstruct c) {
        LOGGER.debug("enter");
        boolean exists = false;
        Map<Connstruct, Reader> map = this.conns;
        synchronized (map) {
            if (this.conns.containsKey(c)) {
                Reader r = this.conns.get(c);
                exists = true;
                r.stopRunning();
                this.conns.remove(c);
            }
        }
        if (exists) {
            try {
                if (null != c.usock) {
                    c.usock.close();
                }
                if (null != c.tsock) {
                    c.tsock.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            map = this.names;
            synchronized (map) {
                ArrayList<String> toRemove = new ArrayList<String>();
                for (String name : this.names.keySet()) {
                    if (this.names.get(name) != c) continue;
                    toRemove.add(name);
                    try {
                        this.send(null, new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameOwnerChanged", "sss", name, c.unique, ""));
                    }
                    catch (DBusException dbe) {
                        LOGGER.debug("", (Throwable)dbe);
                    }
                }
                for (String name : toRemove) {
                    this.names.remove(name);
                }
            }
        }
        LOGGER.debug("exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSock(Socket s) throws IOException {
        LOGGER.debug("enter");
        LOGGER.debug("New Client");
        Connstruct c = new Connstruct(s);
        Reader r = new Reader(c);
        Map<Connstruct, Reader> map = this.conns;
        synchronized (map) {
            this.conns.put(c, r);
        }
        r.start();
        LOGGER.debug("exit");
    }

    @Override
    public void close() {
        this.run.set(false);
        this.interrupt();
    }

    public boolean isRunning() {
        return this.run.get() && this.isAlive();
    }

    public static void syntax() {
        System.out.println("Syntax: DBusDaemon [--version] [-v] [--help] [-h] [--listen address] [-l address] [--print-address] [-r] [--pidfile file] [-p file] [--addressfile file] [-a file] [--unix] [-u] [--tcp] [-t] ");
        System.exit(1);
    }

    public static void version() {
        System.out.println("D-Bus Java Version: " + System.getProperty("Version"));
        System.exit(1);
    }

    public static void saveFile(String data, String file) throws IOException {
        PrintWriter w = new PrintWriter(new FileOutputStream(file));
        w.println(data);
        w.close();
    }

    public static void main(String[] args) throws Exception {
        LOGGER.debug("enter");
        Object addr = null;
        String pidfile = null;
        String addrfile = null;
        boolean printaddress = false;
        boolean unix = true;
        boolean tcp = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                if ("--help".equals(args[i]) || "-h".equals(args[i])) {
                    DBusDaemon.syntax();
                    continue;
                }
                if ("--version".equals(args[i]) || "-v".equals(args[i])) {
                    DBusDaemon.version();
                    continue;
                }
                if ("--listen".equals(args[i]) || "-l".equals(args[i])) {
                    addr = args[++i];
                    continue;
                }
                if ("--pidfile".equals(args[i]) || "-p".equals(args[i])) {
                    pidfile = args[++i];
                    continue;
                }
                if ("--addressfile".equals(args[i]) || "-a".equals(args[i])) {
                    addrfile = args[++i];
                    continue;
                }
                if ("--print-address".equals(args[i]) || "-r".equals(args[i])) {
                    printaddress = true;
                    continue;
                }
                if ("--unix".equals(args[i]) || "-u".equals(args[i])) {
                    unix = true;
                    tcp = false;
                    continue;
                }
                if ("--tcp".equals(args[i]) || "-t".equals(args[i])) {
                    tcp = true;
                    unix = false;
                    continue;
                }
                DBusDaemon.syntax();
            }
        }
        catch (ArrayIndexOutOfBoundsException exAioob) {
            DBusDaemon.syntax();
        }
        if (null == addr && unix) {
            addr = DirectConnection.createDynamicSession();
        } else if (null == addr && tcp) {
            addr = DirectConnection.createDynamicTCPSession();
        }
        BusAddress address = new BusAddress((String)addr);
        if (!address.hasGuid()) {
            addr = (String)addr + ",guid=" + TransportFactory.genGUID();
            address = new BusAddress((String)addr);
        }
        if (printaddress) {
            System.out.println((String)addr);
        }
        if (null != addrfile) {
            DBusDaemon.saveFile((String)addr, addrfile);
        }
        if (null != pidfile) {
            DBusDaemon.saveFile(System.getProperty("Pid"), pidfile);
        }
        LOGGER.info("Binding to {}", addr);
        try (EmbeddedDBusDaemon daemon = new EmbeddedDBusDaemon();){
            daemon.setAddress(address);
            daemon.startInForeground();
        }
        LOGGER.debug("exit");
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public class Reader
    extends Thread {
        private Connstruct conn;
        private WeakReference<Connstruct> weakconn;
        private boolean lrun = true;

        public Reader(Connstruct _conn) {
            this.conn = _conn;
            this.weakconn = new WeakReference<Connstruct>(_conn);
            this.setName("Reader");
        }

        public void stopRunning() {
            this.lrun = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOGGER.debug("enter");
            while (DBusDaemon.this.isRunning() && this.lrun) {
                Message m;
                block7: {
                    m = null;
                    try {
                        m = this.conn.min.readMessage();
                    }
                    catch (IOException ioe) {
                        LOGGER.debug("", (Throwable)ioe);
                        DBusDaemon.this.removeConnection(this.conn);
                    }
                    catch (DBusException dbe) {
                        LOGGER.debug("", (Throwable)dbe);
                        if (!(dbe instanceof FatalException)) break block7;
                        DBusDaemon.this.removeConnection(this.conn);
                    }
                }
                if (null == m) continue;
                LOGGER.info("Read {} from {}", (Object)m, (Object)this.conn.unique);
                MagicMap<Message, WeakReference<Connstruct>> magicMap = DBusDaemon.this.inqueue;
                synchronized (magicMap) {
                    DBusDaemon.this.inqueue.putLast(m, this.weakconn);
                    DBusDaemon.this.inqueue.notifyAll();
                }
            }
            this.conn = null;
            LOGGER.debug("exit");
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public class Sender
    extends Thread {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());

        public Sender() {
            this.setName("Sender");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.logger.debug("enter");
            while (DBusDaemon.this.isRunning()) {
                this.logger.trace("Acquiring lock on outqueue and blocking for data");
                Message m = null;
                List<WeakReference<Connstruct>> wcs = null;
                MagicMap<Message, WeakReference<Connstruct>> magicMap = DBusDaemon.this.outqueue;
                synchronized (magicMap) {
                    while (DBusDaemon.this.outqueue.size() == 0) {
                        try {
                            DBusDaemon.this.outqueue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    m = DBusDaemon.this.outqueue.head();
                    wcs = DBusDaemon.this.outqueue.remove(m);
                }
                if (null != wcs) {
                    for (WeakReference weakReference : wcs) {
                        Connstruct c = (Connstruct)weakReference.get();
                        if (null == c) continue;
                        this.logger.trace("<outqueue> Got message {} for {}", (Object)m, (Object)c.unique);
                        this.logger.info("Sending message {} to {}", (Object)m, (Object)c.unique);
                        try {
                            c.mout.writeMessage(m);
                        }
                        catch (IOException ioe) {
                            this.logger.debug("", (Throwable)ioe);
                            DBusDaemon.this.removeConnection(c);
                        }
                    }
                    continue;
                }
                this.logger.info("Discarding {} connection reaped", (Object)m);
            }
            this.logger.debug("exit");
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public class DBusServer
    extends Thread
    implements DBus,
    Introspectable,
    Peer {
        private final String machineId;
        public Connstruct c;
        public Message m;

        public DBusServer() {
            Object ascii;
            this.setName("Server");
            try {
                ascii = Hexdump.toAscii(MessageDigest.getInstance("MD5").digest(InetAddress.getLocalHost().getHostName().getBytes()));
            }
            catch (UnknownHostException | NoSuchAlgorithmException _ex) {
                ascii = "" + this.hashCode();
            }
            this.machineId = ascii;
        }

        @Override
        public boolean isRemote() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String Hello() {
            LOGGER.debug("enter");
            Object object = this.c;
            synchronized (object) {
                if (null != this.c.unique) {
                    throw new AccessDenied("Connection has already sent a Hello message");
                }
                Object object2 = DBusDaemon.this.uniqueLock;
                synchronized (object2) {
                    this.c.unique = ":1." + ++DBusDaemon.this.nextUnique;
                }
            }
            object = DBusDaemon.this.names;
            synchronized (object) {
                DBusDaemon.this.names.put(this.c.unique, this.c);
            }
            LOGGER.info("Client {} registered", (Object)this.c.unique);
            try {
                DBusDaemon.this.send(this.c, new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameAcquired", "s", this.c.unique));
                DBusSignal s = new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameOwnerChanged", "sss", this.c.unique, "", this.c.unique);
                DBusDaemon.this.send(null, s);
            }
            catch (DBusException dbe) {
                LOGGER.debug("", (Throwable)dbe);
            }
            LOGGER.debug("exit");
            return this.c.unique;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String[] ListNames() {
            String[] ns;
            LOGGER.debug("enter");
            HashMap<String, Connstruct> hashMap = DBusDaemon.this.names;
            synchronized (hashMap) {
                Set<String> nss = DBusDaemon.this.names.keySet();
                ns = nss.toArray(new String[0]);
            }
            LOGGER.debug("exit");
            return ns;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean NameHasOwner(String name) {
            boolean rv;
            LOGGER.debug("enter");
            HashMap<String, Connstruct> hashMap = DBusDaemon.this.names;
            synchronized (hashMap) {
                rv = DBusDaemon.this.names.containsKey(name);
            }
            LOGGER.debug("exit");
            return rv;
        }

        @Override
        public String GetNameOwner(String name) {
            LOGGER.debug("enter");
            Connstruct owner = DBusDaemon.this.names.get(name);
            String o = null == owner ? "" : owner.unique;
            LOGGER.debug("exit");
            return o;
        }

        @Override
        public UInt32 GetConnectionUnixUser(String connection_name) {
            LOGGER.debug("enter");
            LOGGER.debug("exit");
            return new UInt32(0L);
        }

        @Override
        public UInt32 StartServiceByName(String name, UInt32 flags) {
            LOGGER.debug("enter");
            LOGGER.debug("exit");
            return new UInt32(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UInt32 RequestName(String name, UInt32 flags) {
            int rv;
            LOGGER.debug("enter");
            boolean exists = false;
            HashMap<String, Connstruct> hashMap = DBusDaemon.this.names;
            synchronized (hashMap) {
                exists = DBusDaemon.this.names.containsKey(name);
                if (!exists) {
                    DBusDaemon.this.names.put(name, this.c);
                }
            }
            if (exists) {
                rv = 3;
            } else {
                LOGGER.info("Client {} acquired name {}", (Object)this.c.unique, (Object)name);
                rv = 1;
                try {
                    DBusDaemon.this.send(this.c, new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameAcquired", "s", name));
                    DBusDaemon.this.send(null, new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameOwnerChanged", "sss", name, "", this.c.unique));
                }
                catch (DBusException dbe) {
                    LOGGER.debug("", (Throwable)dbe);
                }
            }
            LOGGER.debug("exit");
            return new UInt32(rv);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UInt32 ReleaseName(String name) {
            int rv;
            LOGGER.debug("enter");
            boolean exists = false;
            HashMap<String, Connstruct> hashMap = DBusDaemon.this.names;
            synchronized (hashMap) {
                if (DBusDaemon.this.names.containsKey(name) && DBusDaemon.this.names.get(name).equals(this.c)) {
                    exists = DBusDaemon.this.names.remove(name) != null;
                }
            }
            if (!exists) {
                rv = 2;
            } else {
                LOGGER.info("Client {} acquired name {}", (Object)this.c.unique, (Object)name);
                rv = 1;
                try {
                    DBusDaemon.this.send(this.c, new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameLost", "s", name));
                    DBusDaemon.this.send(null, new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameOwnerChanged", "sss", name, this.c.unique, ""));
                }
                catch (DBusException dbe) {
                    LOGGER.debug("", (Throwable)dbe);
                }
            }
            LOGGER.debug("exit");
            return new UInt32(rv);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void AddMatch(String matchrule) throws MatchRuleInvalid {
            LOGGER.debug("enter");
            LOGGER.trace("Adding match rule: {}", (Object)matchrule);
            List<Connstruct> list = DBusDaemon.this.sigrecips;
            synchronized (list) {
                if (!DBusDaemon.this.sigrecips.contains(this.c)) {
                    DBusDaemon.this.sigrecips.add(this.c);
                }
            }
            LOGGER.debug("exit");
        }

        @Override
        public void RemoveMatch(String matchrule) throws MatchRuleInvalid {
            LOGGER.debug("enter");
            LOGGER.trace("Removing match rule: {}", (Object)matchrule);
            LOGGER.debug("exit");
        }

        @Override
        public String[] ListQueuedOwners(String name) {
            LOGGER.debug("enter");
            LOGGER.debug("exit");
            return new String[0];
        }

        @Override
        public UInt32 GetConnectionUnixProcessID(String connection_name) {
            LOGGER.debug("enter");
            LOGGER.debug("exit");
            return new UInt32(0L);
        }

        @Override
        public Byte[] GetConnectionSELinuxSecurityContext(String a) {
            LOGGER.debug("enter");
            LOGGER.debug("exit");
            return new Byte[0];
        }

        private void handleMessage(Connstruct _c, Message _m) throws DBusException {
            block9: {
                LOGGER.debug("enter");
                LOGGER.trace("Handling message {}  from {}", (Object)_m, (Object)_c.unique);
                if (!(_m instanceof MethodCall)) {
                    return;
                }
                Object[] args = _m.getParameters();
                Class[] cs = new Class[args.length];
                for (int i = 0; i < cs.length; ++i) {
                    cs[i] = args[i].getClass();
                }
                Method meth = null;
                Object rv = null;
                try {
                    meth = DBusServer.class.getMethod(_m.getName(), cs);
                    try {
                        this.c = _c;
                        this.m = _m;
                        rv = meth.invoke((Object)DBusDaemon.this.dbusServer, args);
                        if (null == rv) {
                            DBusDaemon.this.send(_c, new MethodReturn("org.freedesktop.DBus", (MethodCall)_m, null, new Object[0]), true);
                            break block9;
                        }
                        String sig = Marshalling.getDBusType(meth.getGenericReturnType())[0];
                        DBusDaemon.this.send(_c, new MethodReturn("org.freedesktop.DBus", (MethodCall)_m, sig, rv), true);
                    }
                    catch (InvocationTargetException ite) {
                        LOGGER.debug("", (Throwable)ite);
                        DBusDaemon.this.send(_c, new Error("org.freedesktop.DBus", _m, ite.getCause()));
                    }
                    catch (DBusExecutionException dbee) {
                        LOGGER.debug("", (Throwable)dbee);
                        DBusDaemon.this.send(_c, new Error("org.freedesktop.DBus", _m, dbee));
                    }
                    catch (Exception e) {
                        LOGGER.debug("", (Throwable)e);
                        DBusDaemon.this.send(_c, new Error("org.freedesktop.DBus", _c.unique, "org.freedesktop.DBus.Error.GeneralError", _m.getSerial(), "s", "An error occurred while calling " + _m.getName()));
                    }
                }
                catch (NoSuchMethodException exNsm) {
                    DBusDaemon.this.send(_c, new Error("org.freedesktop.DBus", _c.unique, "org.freedesktop.DBus.Error.UnknownMethod", _m.getSerial(), "s", "This service does not support " + _m.getName()));
                }
            }
            LOGGER.debug("exit");
        }

        @Override
        public String getObjectPath() {
            return null;
        }

        @Override
        public String Introspect() {
            return "<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\"\n\"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n<node>\n  <interface name=\"org.freedesktop.DBus.Introspectable\">\n    <method name=\"Introspect\">\n      <arg name=\"data\" direction=\"out\" type=\"s\"/>\n    </method>\n  </interface>\n  <interface name=\"org.freedesktop.DBus\">\n    <method name=\"RequestName\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"in\" type=\"u\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"ReleaseName\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"StartServiceByName\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"in\" type=\"u\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"Hello\">\n      <arg direction=\"out\" type=\"s\"/>\n    </method>\n    <method name=\"NameHasOwner\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"b\"/>\n    </method>\n    <method name=\"ListNames\">\n      <arg direction=\"out\" type=\"as\"/>\n    </method>\n    <method name=\"ListActivatableNames\">\n      <arg direction=\"out\" type=\"as\"/>\n    </method>\n    <method name=\"AddMatch\">\n      <arg direction=\"in\" type=\"s\"/>\n    </method>\n    <method name=\"RemoveMatch\">\n      <arg direction=\"in\" type=\"s\"/>\n    </method>\n    <method name=\"GetNameOwner\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"s\"/>\n    </method>\n    <method name=\"ListQueuedOwners\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"as\"/>\n    </method>\n    <method name=\"GetConnectionUnixUser\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"GetConnectionUnixProcessID\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"GetConnectionSELinuxSecurityContext\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"ay\"/>\n    </method>\n    <method name=\"ReloadConfig\">\n    </method>\n    <signal name=\"NameOwnerChanged\">\n      <arg type=\"s\"/>\n      <arg type=\"s\"/>\n      <arg type=\"s\"/>\n    </signal>\n    <signal name=\"NameLost\">\n      <arg type=\"s\"/>\n    </signal>\n    <signal name=\"NameAcquired\">\n      <arg type=\"s\"/>\n    </signal>\n  </interface>\n</node>";
        }

        @Override
        public void Ping() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOGGER.debug("enter");
            while (DBusDaemon.this.isRunning()) {
                List<WeakReference<Connstruct>> wcs;
                Message msg;
                MagicMap<Message, WeakReference<Connstruct>> magicMap = DBusDaemon.this.localqueue;
                synchronized (magicMap) {
                    while (DBusDaemon.this.localqueue.size() == 0) {
                        try {
                            DBusDaemon.this.localqueue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    msg = DBusDaemon.this.localqueue.head();
                    wcs = DBusDaemon.this.localqueue.remove(msg);
                }
                if (null != wcs) {
                    try {
                        for (WeakReference weakReference : wcs) {
                            Connstruct constructor = (Connstruct)weakReference.get();
                            if (null == constructor) continue;
                            LOGGER.trace("<localqueue> Got message {} from {}", (Object)msg, (Object)constructor);
                            this.handleMessage(constructor, msg);
                        }
                        continue;
                    }
                    catch (DBusException dbe) {
                        LOGGER.debug("", (Throwable)dbe);
                        continue;
                    }
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.info("Discarding {} connection reaped", (Object)msg);
            }
            LOGGER.debug("exit");
        }

        @Override
        public String[] ListActivatableNames() {
            return null;
        }

        @Override
        public Map<String, Variant<?>> GetConnectionCredentials(String _busName) {
            return null;
        }

        @Override
        public Byte[] GetAdtAuditSessionData(String _busName) {
            return null;
        }

        @Override
        public void UpdateActivationEnvironment(Map<String, String>[] _environment) {
        }

        @Override
        public String GetId() {
            return null;
        }

        @Override
        public String GetMachineId() {
            return this.machineId;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class MagicMap<A, B> {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private Map<A, LinkedList<B>> m = new HashMap<A, LinkedList<B>>();
        private LinkedList<A> q = new LinkedList();
        private String name;

        MagicMap(String _name) {
            this.name = _name;
        }

        public A head() {
            return this.q.getFirst();
        }

        public void putFirst(A a, B b) {
            this.logger.debug("<{}> Queueing {{} => {}}", new Object[]{this.name, a, b});
            if (this.m.containsKey(a)) {
                this.m.get(a).add(b);
            } else {
                LinkedList<B> l = new LinkedList<B>();
                l.add(b);
                this.m.put(a, l);
            }
            this.q.addFirst(a);
        }

        public void putLast(A a, B b) {
            this.logger.debug("<{}> Queueing {{} => {}}", new Object[]{this.name, a, b});
            if (this.m.containsKey(a)) {
                this.m.get(a).add(b);
            } else {
                LinkedList<B> l = new LinkedList<B>();
                l.add(b);
                this.m.put(a, l);
            }
            this.q.addLast(a);
        }

        public List<B> remove(A a) {
            this.logger.debug("<{}> Removing {{}}", (Object)this.name, a);
            this.q.remove(a);
            return this.m.remove(a);
        }

        public int size() {
            return this.q.size();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Connstruct {
        public UnixSocket usock;
        public Socket tsock;
        public InputStreamMessageReader min;
        public OutputStreamMessageWriter mout;
        public String unique;

        Connstruct(UnixSocket sock) throws IOException {
            this.usock = sock;
            this.min = new InputStreamMessageReader(sock.getInputStream());
            this.mout = new OutputStreamMessageWriter(sock.getOutputStream());
        }

        Connstruct(Socket sock) throws IOException {
            this.tsock = sock;
            this.min = new InputStreamMessageReader(sock.getInputStream());
            this.mout = new OutputStreamMessageWriter(sock.getOutputStream());
        }

        public String toString() {
            return null == this.unique ? ":?-?" : this.unique;
        }
    }
}

