/*
 * Decompiled with CFR 0.152.
 */
package ca.sineware.prolinuxd.installer;

import ca.sineware.prolinuxd.Main;
import ca.sineware.prolinuxd.gui.installer.InstallerGUI;
import ca.sineware.prolinuxd.gui.weston.Weston;
import ca.sineware.prolinuxd.installer.InstallerConfig;
import com.google.common.io.Resources;
import java.awt.EventQueue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSInstaller {
    private static final Logger log = LoggerFactory.getLogger(OSInstaller.class);
    public InstallerGUI ig;
    public static boolean frameOpen;

    public OSInstaller() throws Exception {
        log.info(System.getenv("XDG_RUNTIME_DIR"));
        String xdgDir = "/run/user/0";
        if ("true".equals(Main.baseSysConf.get((Object)"prolinux", (Object)"weston"))) {
            log.info("Starting Weston Wayland Compositor...");
            try {
                Weston.startWeston();
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("Could not start Weston!");
                throw e;
            }
            Thread.sleep(2000L);
            File waylandSocket = new File(xdgDir + "/wayland-0");
            while (!waylandSocket.exists()) {
                log.info("Waiting for Weston to start...");
                Thread.sleep(2000L);
            }
        }
        try {
            EventQueue.invokeLater(() -> {
                try {
                    this.ig = new InstallerGUI();
                    frameOpen = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.info("Could not start installer GUI!");
            System.exit(-3);
        }
    }

    public static void installOS(InstallerConfig conf) throws Exception {
        log.info("Executing install commands...");
        log.info("Formatting drive " + conf.targetDisk + " for " + conf.hostname);
        String lvmPart = "/dev/disk/by-partuuid/5d4e6148-3e2b-4ca3-bb6a-7f97d7a54070";
        Path path = Paths.get("/dev/ProLinuxVG", new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            log.info("Detected previous ProLinux installation (ProLinuxVG), removing it...");
            OSInstaller.singleStepCmd("lvchange -an /dev/ProLinuxVG/lvol_grub", false);
            OSInstaller.singleStepCmd("lvchange -an /dev/ProLinuxVG/lvol_config", false);
            OSInstaller.singleStepCmd("lvchange -an /dev/ProLinuxVG/lvol_root_a", false);
            OSInstaller.singleStepCmd("lvchange -an /dev/ProLinuxVG/lvol_root_b", false);
            OSInstaller.singleStepCmd("lvchange -an /dev/ProLinuxVG/lvol_data", false);
            OSInstaller.singleStepCmd("lvremove -y /dev/ProLinuxVG/lvol_grub", false);
            OSInstaller.singleStepCmd("lvremove -y /dev/ProLinuxVG/lvol_config", false);
            OSInstaller.singleStepCmd("lvremove -y /dev/ProLinuxVG/lvol_root_a", false);
            OSInstaller.singleStepCmd("lvremove -y /dev/ProLinuxVG/lvol_root_b", false);
            OSInstaller.singleStepCmd("lvremove -y /dev/ProLinuxVG/lvol_data", false);
            OSInstaller.singleStepCmd("vgchange -an ProLinuxVG");
            OSInstaller.singleStepCmd("vgremove -y ProLinuxVG");
            OSInstaller.singleStepCmd("pvremove " + lvmPart);
            OSInstaller.singleStepCmd("ls -l /dev/mapper");
        }
        log.info("Formatting with default GPT layout...");
        URL layoutUrl = Resources.getResource((String)"layout.sgdisk");
        String layoutString = "";
        layoutString = Resources.toString((URL)layoutUrl, (Charset)StandardCharsets.UTF_8);
        ByteArrayInputStream layoutInput = new ByteArrayInputStream(layoutString.getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream layoutOutput = new ByteArrayOutputStream();
        CommandLine partitionCmd = CommandLine.parse((String)("sfdisk " + conf.targetDisk));
        DefaultExecutor partitionExec = new DefaultExecutor();
        partitionExec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)layoutOutput, (OutputStream)layoutOutput, (InputStream)layoutInput));
        partitionExec.execute(partitionCmd);
        log.info(layoutOutput.toString());
        OSInstaller.singleStepCmd("lvmdiskscan");
        log.info("Creating LVM physical volume on " + lvmPart + "...");
        OSInstaller.singleStepCmd("pvcreate -ffy " + lvmPart);
        log.info("Physical volume summary: ");
        OSInstaller.singleStepCmd("pvdisplay");
        OSInstaller.singleStepCmd("pvscan");
        log.info("Creating LVM volume group...");
        OSInstaller.singleStepCmd("vgcreate ProLinuxVG " + lvmPart);
        log.info("Extending VG over additional volumes...");
        log.info("Volume group summary: ");
        OSInstaller.singleStepCmd("vgdisplay");
        log.info("Creating LVM logical volumes");
        OSInstaller.singleStepCmd("lvcreate -y -L 16M ProLinuxVG -n lvol_grub");
        OSInstaller.singleStepCmd("lvcreate -y -L 128M ProLinuxVG -n lvol_config");
        OSInstaller.singleStepCmd("lvcreate -y -L 4G ProLinuxVG -n lvol_root_a");
        OSInstaller.singleStepCmd("lvcreate -y -L 4G ProLinuxVG -n lvol_root_b");
        OSInstaller.singleStepCmd("lvcreate -y -l 100%FREE ProLinuxVG -n lvol_data");
        log.info("Logical volumes summary: ");
        OSInstaller.singleStepCmd("lvdisplay");
        log.info("Formatting grub, config, and data logical volumes:");
        OSInstaller.singleStepCmd("mkfs.ext4 -F /dev/ProLinuxVG/lvol_grub");
        OSInstaller.singleStepCmd("mkfs.ext4 -F /dev/ProLinuxVG/lvol_config");
        OSInstaller.singleStepCmd("mkfs.ext4 -F /dev/ProLinuxVG/lvol_data");
        log.info("Extracting RootFS to logical volume Root A");
        OSInstaller.singleStepCmd("dd if=/system/prolinux-server.squashfs.img of=/dev/ProLinuxVG/lvol_root_a bs=4096 status=progress");
        log.info("Mounting directories...");
        OSInstaller.singleStepCmd("mount /dev/ProLinuxVG/lvol_root_a /mnt");
        OSInstaller.singleStepCmd("mount /dev/ProLinuxVG/lvol_grub /mnt/boot/");
        log.info("Installing GRUB...");
        OSInstaller.singleStepCmd("grub-install --boot-directory /mnt/boot /dev/sda");
        OSInstaller.singleStepCmd("cp /system/grub-hdd.cfg /mnt/boot/grub/grub.cfg");
        log.info("Writing system configuration file...");
        log.info("Installation successful!");
        log.info("Please reboot and remove the installation media.");
    }

    public static int singleStepCmd(String cmd) throws Exception {
        return OSInstaller.singleStepCmd(cmd, true);
    }

    public static int singleStepCmd(String cmd, boolean throwOnExitCode) throws Exception {
        Thread.sleep(1000L);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream outputErrStream = new ByteArrayOutputStream();
        CommandLine cmdLine = CommandLine.parse((String)("sudo " + cmd));
        DefaultExecutor cmdExec = new DefaultExecutor();
        cmdExec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)outputStream, (OutputStream)outputErrStream, null));
        log.info("-----------------------------------------------");
        log.info("About to execute: " + cmd);
        cmdExec.execute(cmdLine, (ExecuteResultHandler)resultHandler);
        while (!resultHandler.hasResult()) {
            Thread.sleep(50L);
            if (outputStream.toString().length() != 0) {
                log.info("[stdout] " + outputStream.toString());
            }
            if (outputErrStream.toString().length() != 0) {
                log.info("[stderr] " + outputErrStream.toString());
            }
            outputStream.reset();
        }
        int exitCode = resultHandler.getExitValue();
        log.info("Exit Code: " + exitCode);
        if (throwOnExitCode && exitCode != 0) {
            throw new Exception("Command " + cmd + " exited with error code " + exitCode);
        }
        return exitCode;
    }
}

