/*
 * Decompiled with CFR 0.152.
 */
package ca.sineware.prolinuxd;

import ca.sineware.prolinuxd.Main;
import ca.sineware.prolinuxd.ws.Action;
import ca.sineware.prolinuxd.ws.payloads.ErrorPayload;
import ca.sineware.prolinuxd.ws.payloads.hello.HelloAckPayload;
import ca.sineware.prolinuxd.ws.payloads.hello.HelloPayload;
import ca.sineware.prolinuxd.ws.payloads.hello.HelloPayloadInfo;
import ca.sineware.prolinuxd.ws.payloads.unsafe_exec_cmd.StreamTerminalPayload;
import ca.sineware.prolinuxd.ws.payloads.unsafe_exec_cmd.UnsafeExecCmdPayload;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudClient
extends WebSocketClient {
    private static final Logger log = LoggerFactory.getLogger(CloudClient.class);
    Gson gson = new Gson();
    HelloAckPayload self;

    public CloudClient(URI serverUri, Draft protocolDraft) {
        super(serverUri, protocolDraft);
    }

    public CloudClient(URI serverURI) {
        super(serverURI);
    }

    public void onOpen(ServerHandshake handshakedata) {
        System.out.println("new connection opened");
        this.send("{\"action\":\"ping\",\"payload\":{}}");
        Action helloAction = new Action();
        HelloPayload helloPayload = null;
        try {
            helloPayload = new HelloPayload("device", Main.cloudToken, new HelloPayloadInfo(InetAddress.getLocalHost().getHostName()));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            System.exit(-6);
        }
        helloAction.action = "hello";
        helloAction.payload = helloPayload;
        String jsonMsg = this.gson.toJson(helloAction);
        System.out.println(jsonMsg);
        this.send(jsonMsg);
    }

    public void onMessage(String message) {
        System.out.println("received message: " + message);
        JsonParser parser = new JsonParser();
        JsonObject msgJsonObj = parser.parse(message).getAsJsonObject();
        System.out.println(msgJsonObj.get("action"));
        switch (msgJsonObj.get("action").getAsString()) {
            case "ping-ack": {
                Type actionType = new TypeToken<Action<String>>(){}.getType();
                Action msg = (Action)this.gson.fromJson(message, actionType);
                System.out.println((String)msg.payload);
                break;
            }
            case "hello-ack": {
                Type actionType = new TypeToken<Action<HelloAckPayload>>(){}.getType();
                Action msg = (Action)this.gson.fromJson(message, actionType);
                this.self = (HelloAckPayload)msg.payload;
                log.info("Successfully authenticated with WS Gateway!");
                break;
            }
            case "unsafe-exec-cmd": {
                log.info("About to unsafely execute a command");
                Type actionType = new TypeToken<Action<UnsafeExecCmdPayload>>(){}.getType();
                Action msg = (Action)this.gson.fromJson(message, actionType);
                try {
                    Runtime rt = Runtime.getRuntime();
                    Process pr = rt.exec(((UnsafeExecCmdPayload)msg.payload).cmd);
                    BufferedReader input = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                    String line = null;
                    while ((line = input.readLine()) != null) {
                        System.out.println(line);
                        Action streamAction = new Action();
                        StreamTerminalPayload streamPayload = new StreamTerminalPayload();
                        streamPayload.userID = ((UnsafeExecCmdPayload)msg.payload).requestUserID;
                        streamPayload.output = line;
                        streamAction.action = "stream-terminal";
                        streamAction.payload = streamPayload;
                        String jsonMsg = this.gson.toJson(streamAction);
                        System.out.println(jsonMsg);
                        this.send(jsonMsg);
                    }
                    int exitVal = pr.waitFor();
                    System.out.println("Exited with error code " + exitVal);
                }
                catch (Exception exception) {}
                break;
            }
            case "error": {
                Type actionType = new TypeToken<Action<ErrorPayload>>(){}.getType();
                Action error = (Action)this.gson.fromJson(message, actionType);
                log.error("Received error from gateway: " + ((ErrorPayload)error.payload).message);
                break;
            }
            default: {
                log.error("Unknown Action: " + msgJsonObj.get("action").getAsString());
            }
        }
    }

    public void onClose(int code, String reason, boolean remote) {
        System.out.println("closed with exit code " + code + " additional info: " + reason);
    }

    public void onError(Exception ex) {
        System.err.println("an error occurred:" + ex);
    }
}

