/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.freedesktop.dbus.annotations.Position;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class Container {
    private static Map<Type, Type[]> typecache = new HashMap<Type, Type[]>();
    private Object[] parameters = null;

    static void putTypeCache(Type k, Type[] v) {
        typecache.put(k, v);
    }

    static Type[] getTypeCache(Type k) {
        return typecache.get(k);
    }

    Container() {
    }

    private void setup() {
        Field[] fs = this.getClass().getDeclaredFields();
        Object[] args = new Object[fs.length];
        int diff = 0;
        for (Field f : fs) {
            Position p = f.getAnnotation(Position.class);
            f.setAccessible(true);
            if (null == p) {
                ++diff;
                continue;
            }
            try {
                args[p.value()] = f.get(this);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        this.parameters = new Object[args.length - diff];
        System.arraycopy(args, 0, this.parameters, 0, this.parameters.length);
    }

    public final Object[] getParameters() {
        if (null != this.parameters) {
            return this.parameters;
        }
        this.setup();
        return this.parameters;
    }

    public final String toString() {
        String s = this.getClass().getName() + "<";
        if (null == this.parameters) {
            this.setup();
        }
        if (0 == this.parameters.length) {
            return s + ">";
        }
        for (Object o : this.parameters) {
            s = s + o + ", ";
        }
        return s.replaceAll(", $", ">");
    }

    public final boolean equals(Object other) {
        if (other instanceof Container) {
            Container that = (Container)other;
            if (this.getClass().equals(that.getClass())) {
                return Arrays.equals(this.getParameters(), that.getParameters());
            }
            return false;
        }
        return false;
    }
}

