"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.runCmd = void 0;
const child_process_1 = require("child_process");
const logging_1 = require("../logging");
async function runCmd(cmd, args, streamStdout = false, timeout = 30000) {
    logging_1.log.info(`About to exec: ${cmd} ${args.join(" ")}`);
    return new Promise((resolve, reject) => {
        const proc = (0, child_process_1.spawn)(cmd, args);
        let stdout = "";
        let stderr = "";
        proc.stdout.on("data", (data) => {
            stdout += data.toString();
            if (streamStdout)
                logging_1.log.info(data.toString());
        });
        proc.stderr.on("data", (data) => {
            stderr += data.toString();
            if (streamStdout)
                logging_1.log.error(data.toString());
        });
        proc.on("close", (code) => {
            if (code === 0) {
                resolve(stdout);
            }
            else {
                reject(new Error(`Command ${cmd} ${args.join(" ")} exited with code ${code}, stderr: ${stderr}`));
            }
        });
        // Timeout after 30 seconds
        setTimeout(() => {
            proc.kill();
            reject(new Error(`Command ${cmd} ${args.join(" ")} timed out`));
        }, timeout);
    });
}
exports.runCmd = runCmd;
//# sourceMappingURL=runCmd.js.map