import exec from "../helpers/exec"
import { BUILD_DIR, ROOTFS_DIR } from "../helpers/consts";
export function compileQt() {
    const url = "https://download.qt.io/official_releases/qt/6.6/6.6.1/single/qt-everywhere-src-6.6.1.tar.xz";
    exec(`sudo arch-chroot ${ROOTFS_DIR} /bin/bash -x <<'EOF'
        set -e

        mkdir -pv /tmp/qt-build
        cd /tmp/qt-build/
        wget ${url} -O qt.tar.xz
        tar -xvf qt.tar.xz --strip-components=1

        ./configure -DQT_FEATURE_opengles2=ON
        cmake --build . --parallel
        cmake --install .
        
        cd ..

        # clean up
        rm -rf /tmp/qt-build

EOF`);
}
