"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.verifyStateIntegrity = exports.untouchedState = exports.state = void 0;
const node_fs_1 = __importDefault(require("node:fs"));
const node_path_1 = __importDefault(require("node:path"));
const TOML = __importStar(require("@ltd/j-toml"));
const vanilla_1 = require("valtio/vanilla");
const logging_1 = require("../logging");
const constants_1 = require("../constants");
logging_1.log.info("Initializing system state container...");
exports.state = {
    config: (0, vanilla_1.proxy)({
        prolinuxd: {
            modules: [
                "plasma-mobile-nightly",
                "ocs2",
                "pl2"
            ]
        },
        ocs2: {
            gateway_url: "wss://update.sineware.ca/gateway",
            client_type: "prolinux,plasma-mobile-nightly",
            access_token: ""
        },
        pl2: {
            selected_root: "a",
            locked_root: true,
            hostname: "",
            disable_kexec: false,
            remote_api: true,
            user_shadow: "",
        },
    }),
    extraConfig: (0, vanilla_1.proxy)({
        server_roles: {
            webserver: {
                name: constants_1.ServerRoleType.WEBSERVER,
                description: "Webserver Role",
                enabled: false,
                config: {
                    port: 80,
                    root: "/var/www/html",
                    index: "index.html",
                    ssl: false,
                    ssl_cert: "",
                    ssl_key: ""
                }
            },
            secure_switch: {
                name: constants_1.ServerRoleType.SECURE_SWITCH_APPLIANCE,
                description: "SecureSwitch Role",
                enabled: false,
                config: {
                    interfaces: [],
                    bridge_mac: "",
                    dhcp: true,
                    ip: "",
                    netmask: "",
                    gateway: "",
                    dns: "",
                },
            },
        }
    }),
    tracked: (0, vanilla_1.proxy)({}),
    untracked: {
        passwordServiceWatcher: null,
        NMNetworksServiceWatcher: null,
    },
    cloud: null,
    localSocket: null,
};
exports.untouchedState = JSON.parse(JSON.stringify(exports.state));
// ensure that all properties are present and no extra from untouchedState in state, deeply
function verifyStateIntegrity() {
    const missing = [];
    const extra = [];
    const verify = (obj, untouched, path = "") => {
        for (const key in untouched) {
            if (!(key in obj)) {
                missing.push(`${path}.${key}`);
            }
            else if (typeof untouched[key] === "object") {
                verify(obj[key], untouched[key], `${path}.${key}`);
            }
        }
        for (const key in obj) {
            if (!(key in untouched)) {
                extra.push(`${path}.${key}`);
            }
            else if (typeof untouched[key] === "object") {
                verify(obj[key], untouched[key], `${path}.${key}`);
            }
        }
    };
    verify(exports.state, exports.untouchedState);
    const valid = missing.length === 0 && extra.length === 0;
    return {
        valid,
        missing,
        extra,
        msg: valid ? "State is valid" : `State is invalid, missing: ${missing.join(", ")}, extra: ${extra.join(", ")}`
    };
}
exports.verifyStateIntegrity = verifyStateIntegrity;
(0, vanilla_1.subscribe)(exports.state.config, () => {
    logging_1.log.info("[State] Config updated, saving to disk...");
    node_fs_1.default.writeFileSync(process.env.CONFIG_FILE ?? node_path_1.default.join(__dirname, "prolinux.toml"), TOML.stringify(exports.state.config, {
        newline: "\n"
    }));
    console.log("Updating grub source...");
    let grubSource = node_fs_1.default.readFileSync("/sineware/data/grub-source.cfg", "utf-8");
    grubSource = grubSource.replace(/set selected_root=".*"/, `set selected_root="${exports.state.config.pl2.selected_root}"`);
    console.log("Writing grub source...");
    node_fs_1.default.writeFileSync("/sineware/data/grub-source.cfg", grubSource);
});
(0, vanilla_1.subscribe)(exports.state.extraConfig, () => {
    logging_1.log.info("[State] Extra Config updated, saving to disk...");
    // Get the directory of the full file path set in CONFIG_FILE
    const configDir = node_path_1.default.dirname(process.env.CONFIG_FILE ?? node_path_1.default.join(__dirname, "extra-config.json"));
    node_fs_1.default.writeFileSync(node_path_1.default.join(configDir, "extra-config.json"), JSON.stringify(exports.state.extraConfig, null, 4));
});
//# sourceMappingURL=systemStateContainer.js.map