"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.log = exports.logger = exports.logBuffer = void 0;
const _1 = require(".");
exports.logBuffer = [];
function logger(msg, type, from = "prolinuxd") {
    if (exports.logBuffer.length > 1024) {
        exports.logBuffer.shift();
    }
    exports.logBuffer.push(`[${type}] ${msg}`);
    if (_1.cloud?.ready) {
        _1.cloud.ws?.send(JSON.stringify({
            action: "device-log",
            payload: {
                uuid: _1.cloud.uuid,
                type,
                from,
                msg
            }
        }));
    }
    else {
        // todo plasma-mobile-nightly only
        //fs.appendFileSync("/dev/tty1", `[prolinuxd] [${type}] ${msg}\n`);
    }
    console.log(`[prolinuxd] [${type}] ${msg}`);
}
exports.logger = logger;
exports.log = {
    info: (msg) => logger(msg, "info"),
    error: (msg) => logger(msg, "error"),
    debug: (msg) => logger(msg, "debug"),
    getLogs: () => exports.logBuffer
};
//# sourceMappingURL=logging.js.map