/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Util {
    private static final Logger LOGGER;
    private static final char[] SYMBOLS;

    private Util() {
    }

    public static Properties readProperties(File _file) {
        if (_file.exists()) {
            try {
                return Util.readProperties(new FileInputStream(_file));
            }
            catch (FileNotFoundException _ex) {
                LOGGER.info("Could not load properties file: " + _file, (Throwable)_ex);
            }
        }
        return null;
    }

    public static Properties readProperties(InputStream _stream) {
        Properties props = new Properties();
        if (_stream == null) {
            return null;
        }
        try {
            props.load(_stream);
            return props;
        }
        catch (IOException | NumberFormatException _ex) {
            LOGGER.warn("Could not properties: ", (Throwable)_ex);
            return null;
        }
    }

    public static boolean isBlank(String _str) {
        if (_str == null) {
            return true;
        }
        return _str.trim().isEmpty();
    }

    public static boolean isEmpty(String _str) {
        if (_str == null) {
            return true;
        }
        return _str.isEmpty();
    }

    public static String randomString(int _length) {
        if (_length <= 0) {
            return "";
        }
        Random random = new Random();
        char[] buf = new char[_length];
        for (int idx = 0; idx < buf.length; ++idx) {
            buf[idx] = SYMBOLS[random.nextInt(SYMBOLS.length)];
        }
        return new String(buf);
    }

    public static String upperCaseFirstChar(String _str) {
        if (_str == null) {
            return null;
        }
        if (_str.isEmpty()) {
            return _str;
        }
        return _str.substring(0, 1).toUpperCase() + _str.substring(1);
    }

    public static String snakeToCamelCase(String _input) {
        if (Util.isBlank(_input)) {
            return _input;
        }
        Pattern compile = Pattern.compile("_[a-zA-Z]");
        Matcher matcher = compile.matcher(_input);
        String result = _input;
        while (matcher.find()) {
            String match = matcher.group();
            String replacement = match.replace("_", "");
            replacement = replacement.toUpperCase();
            result = result.replaceFirst(match, replacement);
        }
        return result;
    }

    public static String abbreviate(String _str, int _length) {
        if (_str == null) {
            return null;
        }
        if (_str.length() <= _length) {
            return _str;
        }
        String abbr = _str.substring(0, _length - 3) + "...";
        return abbr;
    }

    public static boolean isValidNetworkPort(int _port, boolean _allowWellKnown) {
        if (_allowWellKnown) {
            return _port > 0 && _port < 65536;
        }
        return _port > 1024 && _port < 65536;
    }

    public static boolean isValidNetworkPort(String _str, boolean _allowWellKnown) {
        if (Util.isInteger(_str, false)) {
            return Util.isValidNetworkPort(Integer.parseInt(_str), _allowWellKnown);
        }
        return false;
    }

    public static boolean isInteger(String _str, boolean _allowNegative) {
        if (_str == null) {
            return false;
        }
        String regex = "[0-9]+$";
        regex = _allowNegative ? "^-?" + regex : "^" + regex;
        return _str.matches(regex);
    }

    public static List<String> readFileToList(String _fileName) {
        List<String> localText = Util.getTextfileFromUrl(_fileName, Charset.defaultCharset(), false);
        return localText;
    }

    public static String readFileToString(File _file) {
        return String.join((CharSequence)System.lineSeparator(), Util.readFileToList(_file.getAbsolutePath()));
    }

    public static List<String> getTextfileFromUrl(String _url, Charset _charset, boolean _silent) {
        if (_url == null) {
            return null;
        }
        String fileUrl = _url;
        if (!fileUrl.contains("://")) {
            fileUrl = "file://" + fileUrl;
        }
        try {
            URL dlUrl = fileUrl.startsWith("file:/") ? new URL("file", "", fileUrl.replaceFirst("file:\\/{1,2}", "")) : new URL(fileUrl);
            URLConnection urlConn = dlUrl.openConnection();
            urlConn.setDoInput(true);
            urlConn.setUseCaches(false);
            return Util.readTextFileFromStream(urlConn.getInputStream(), _charset, _silent);
        }
        catch (IOException _ex) {
            if (!_silent) {
                LOGGER.warn("Error while reading file:", (Throwable)_ex);
            }
            return null;
        }
    }

    public static List<String> readTextFileFromStream(InputStream _input, Charset _charset, boolean _silent) {
        if (_input == null) {
            return null;
        }
        try {
            ArrayList<String> fileContent;
            try (BufferedReader dis = new BufferedReader(new InputStreamReader(_input, _charset));){
                String s;
                fileContent = new ArrayList<String>();
                while ((s = dis.readLine()) != null) {
                    fileContent.add(s);
                }
            }
            return fileContent.size() > 0 ? fileContent : null;
        }
        catch (IOException _ex) {
            if (!_silent) {
                LOGGER.warn("Error while reading file:", (Throwable)_ex);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeTextFile(String _fileName, String _fileContent, Charset _charset, boolean _append) {
        File file;
        if (Util.isBlank(_fileName)) {
            return false;
        }
        String allText = "";
        if (_append && (file = new File(_fileName)).exists()) {
            allText = Util.readFileToString(file);
        }
        allText = allText + _fileContent;
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(_fileName), _charset);
            writer.write(allText);
        }
        catch (IOException _ex) {
            LOGGER.error("Could not write file to '" + _fileName + "'", (Throwable)_ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException _ex) {
                LOGGER.error("Error while closing file '" + _fileName + "'", (Throwable)_ex);
                return false;
            }
        }
        return true;
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException _ex) {
            return null;
        }
    }

    public static String getCurrentUser() {
        String[] sysPropParms = new String[]{"user.name", "USER", "USERNAME"};
        for (int i = 0; i < sysPropParms.length; ++i) {
            String val = System.getProperty(sysPropParms[i]);
            if (Util.isEmpty(val)) continue;
            return val;
        }
        return null;
    }

    public static boolean isMacOs() {
        String osName = System.getProperty("os.name");
        return osName == null ? false : osName.toLowerCase().startsWith("mac");
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName == null ? false : osName.toLowerCase().startsWith("windows");
    }

    static {
        char ch;
        LOGGER = LoggerFactory.getLogger(Util.class);
        StringBuilder tmp = new StringBuilder();
        for (ch = '0'; ch <= '9'; ch = (char)(ch + '\u0001')) {
            tmp.append(ch);
        }
        for (ch = 'a'; ch <= 'z'; ch = (char)(ch + '\u0001')) {
            tmp.append(ch);
        }
        for (ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            tmp.append(ch);
        }
        SYMBOLS = tmp.toString().toCharArray();
    }
}

