/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.messages;

import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.MethodTuple;
import org.freedesktop.dbus.StrongReference;
import org.freedesktop.dbus.Tuple;
import org.freedesktop.dbus.TypeRef;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.annotations.DBusMemberName;
import org.freedesktop.dbus.annotations.DBusProperties;
import org.freedesktop.dbus.annotations.DBusProperty;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.interfaces.Peer;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.utils.DBusNamingUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ExportedObject {
    private Map<MethodTuple, Method> methods = new HashMap<MethodTuple, Method>();
    private Reference<DBusInterface> object;
    private String introspectionData;

    public ExportedObject(DBusInterface _object, boolean _weakreferences) throws DBusException {
        this.object = _weakreferences ? new WeakReference<DBusInterface>(_object) : new StrongReference<DBusInterface>(_object);
        Set<Class<?>> implementedInterfaces = this.getDBusInterfaces(_object.getClass());
        implementedInterfaces.add(Introspectable.class);
        implementedInterfaces.add(Peer.class);
        this.introspectionData = this.generateIntrospectionXml(implementedInterfaces);
    }

    protected String generateAnnotationsXml(AnnotatedElement c) {
        StringBuilder ans = new StringBuilder();
        for (Annotation a : c.getDeclaredAnnotations()) {
            if (!a.annotationType().isAnnotationPresent(DBusInterfaceName.class)) continue;
            Class<? extends Annotation> t = a.annotationType();
            String value = "";
            try {
                Method m = t.getMethod("value", new Class[0]);
                if (m != null) {
                    value = m.invoke((Object)a, new Object[0]).toString();
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException m) {
                // empty catch block
            }
            String name = DBusNamingUtil.getAnnotationName(t);
            ans.append("  <annotation name=\"").append(name).append("\" value=\"").append(value).append("\" />\n");
        }
        return ans.toString();
    }

    protected String generatePropertyXml(DBusProperty property) throws DBusException {
        String propertyTypeString;
        Class<?> propertyTypeClass = property.type();
        if (TypeRef.class.isAssignableFrom(propertyTypeClass)) {
            Type actualType = Arrays.stream(propertyTypeClass.getGenericInterfaces()).filter(t -> t instanceof ParameterizedType).map(t -> (ParameterizedType)t).filter(t -> TypeRef.class.equals((Object)t.getRawType())).map(t -> t.getActualTypeArguments()[0]).findFirst().orElseThrow(() -> new DBusException("Could not read TypeRef type for property '" + property.name() + "'"));
            propertyTypeString = Marshalling.getDBusType(new Type[]{actualType});
        } else {
            propertyTypeString = List.class.equals(propertyTypeClass) ? "av" : (Map.class.equals(propertyTypeClass) ? "a{vv}" : Marshalling.getDBusType(new Type[]{propertyTypeClass}));
        }
        String access = property.access().getAccessName();
        return "<property name=\"" + property.name() + "\" type=\"" + propertyTypeString + "\" access=\"" + access + "\" />";
    }

    protected String generatePropertiesXml(Class<?> c) throws DBusException {
        DBusProperty property;
        StringBuilder xml = new StringBuilder();
        DBusProperties properties = c.getAnnotation(DBusProperties.class);
        if (properties != null) {
            for (DBusProperty property2 : properties.value()) {
                xml.append("  ").append(this.generatePropertyXml(property2)).append("\n");
            }
        }
        if ((property = c.getAnnotation(DBusProperty.class)) != null) {
            xml.append("  ").append(this.generatePropertyXml(property)).append("\n");
        }
        return xml.toString();
    }

    protected String generateMethodsXml(Class<?> c) throws DBusException {
        StringBuilder sb = new StringBuilder();
        for (Method meth : c.getDeclaredMethods()) {
            if (!Modifier.isPublic(meth.getModifiers())) continue;
            String ms = "";
            String methodName = DBusNamingUtil.getMethodName(meth);
            if (methodName.length() > 255) {
                throw new DBusException("Introspected method name exceeds 255 characters. Cannot export objects with method " + methodName);
            }
            sb.append("  <method name=\"").append(methodName).append("\" >\n");
            sb.append(this.generateAnnotationsXml(meth));
            for (Class<?> ex : meth.getExceptionTypes()) {
                if (!DBusExecutionException.class.isAssignableFrom(ex)) continue;
                sb.append("   <annotation name=\"org.freedesktop.DBus.Method.Error\" value=\"").append(AbstractConnection.DOLLAR_PATTERN.matcher(ex.getName()).replaceAll(".")).append("\" />\n");
            }
            for (Type pt : meth.getGenericParameterTypes()) {
                for (String s : Marshalling.getDBusType(pt)) {
                    sb.append("   <arg type=\"").append(s).append("\" direction=\"in\"/>\n");
                    ms = ms + s;
                }
            }
            if (!Void.TYPE.equals(meth.getGenericReturnType())) {
                if (Tuple.class.isAssignableFrom(meth.getReturnType())) {
                    Type[] ts;
                    ParameterizedType tc = (ParameterizedType)meth.getGenericReturnType();
                    for (Type t : ts = tc.getActualTypeArguments()) {
                        if (t == null) continue;
                        for (String s : Marshalling.getDBusType(t)) {
                            sb.append("   <arg type=\"").append(s).append("\" direction=\"out\"/>\n");
                        }
                    }
                } else {
                    if (Object[].class.equals((Object)meth.getGenericReturnType())) {
                        throw new DBusException("Return type of Object[] cannot be introspected properly");
                    }
                    for (String s : Marshalling.getDBusType(meth.getGenericReturnType())) {
                        sb.append("   <arg type=\"").append(s).append("\" direction=\"out\"/>\n");
                    }
                }
            }
            sb.append("  </method>\n");
            this.methods.putIfAbsent(new MethodTuple(methodName, ms), meth);
        }
        return sb.toString();
    }

    protected String generateSignalsXml(Class<?> c) throws DBusException {
        StringBuilder sb = new StringBuilder();
        for (Class<?> sig : c.getDeclaredClasses()) {
            if (!DBusSignal.class.isAssignableFrom(sig)) continue;
            String signalName = DBusNamingUtil.getSignalName(sig);
            if (sig.isAnnotationPresent(DBusMemberName.class)) {
                DBusSignal.addSignalMap(sig.getSimpleName(), signalName);
            }
            if (signalName.length() > 255) {
                throw new DBusException("Introspected signal name exceeds 255 characters. Cannot export objects with signals of type " + signalName);
            }
            sb.append("  <signal name=\"").append(signalName).append("\">\n");
            Constructor<?> con = sig.getConstructors()[0];
            Type[] ts = con.getGenericParameterTypes();
            for (int j = 1; j < ts.length; ++j) {
                for (String s : Marshalling.getDBusType(ts[j])) {
                    sb.append("   <arg type=\"").append(s).append("\" direction=\"out\" />\n");
                }
            }
            sb.append(this.generateAnnotationsXml(sig));
            sb.append("  </signal>\n");
        }
        return sb.toString();
    }

    protected Set<Class<?>> getDBusInterfaces(Class<?> inputClazz) {
        Objects.requireNonNull(inputClazz, "inputClazz must not be null");
        LinkedHashSet result = new LinkedHashSet();
        LinkedHashSet<Class> checked = new LinkedHashSet<Class>();
        LinkedList toCheck = new LinkedList();
        toCheck.add(inputClazz);
        while (!toCheck.isEmpty()) {
            Class clazz = (Class)toCheck.poll();
            checked.add(clazz);
            Class superClass = clazz.getSuperclass();
            if (superClass != null && DBusInterface.class.isAssignableFrom(superClass)) {
                toCheck.add(superClass);
            }
            List<Class<?>> interfaces = Arrays.asList(clazz.getInterfaces());
            if (clazz.isInterface() && interfaces.contains(DBusInterface.class)) {
                result.add(clazz);
            }
            interfaces.stream().filter(DBusInterface.class::isAssignableFrom).filter(i -> i != DBusInterface.class).filter(i -> !checked.contains(i)).forEach(toCheck::add);
        }
        return result;
    }

    private String generateIntrospectionXml(Set<Class<?>> interfaces) throws DBusException {
        StringBuilder sb = new StringBuilder();
        for (Class<?> iface : interfaces) {
            String ifaceName = DBusNamingUtil.getInterfaceName(iface);
            if (ifaceName.equals(iface.getSimpleName())) {
                throw new DBusException("DBusInterfaces cannot be declared outside a package");
            }
            if (ifaceName.length() > 255) {
                throw new DBusException("Introspected interface name exceeds 255 characters. Cannot export objects of type " + ifaceName);
            }
            sb.append(" <interface name=\"").append(ifaceName).append("\">\n");
            sb.append(this.generateAnnotationsXml(iface));
            sb.append(this.generateMethodsXml(iface));
            sb.append(this.generatePropertiesXml(iface));
            sb.append(this.generateSignalsXml(iface));
            sb.append(" </interface>\n");
        }
        return sb.toString();
    }

    public Map<MethodTuple, Method> getMethods() {
        return this.methods;
    }

    public Reference<DBusInterface> getObject() {
        return this.object;
    }

    public String getIntrospectiondata() {
        return this.introspectionData;
    }
}

