/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.freedesktop.dbus.DBusAsyncReply;
import org.freedesktop.dbus.DBusCallInfo;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.InternalSignal;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.MethodTuple;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.SignalTuple;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.FallbackContainer;
import org.freedesktop.dbus.connections.GlobalHandler;
import org.freedesktop.dbus.connections.IDisconnectAction;
import org.freedesktop.dbus.connections.IncomingMessageThread;
import org.freedesktop.dbus.connections.PendingCallbackManager;
import org.freedesktop.dbus.connections.transports.AbstractTransport;
import org.freedesktop.dbus.connections.transports.TransportFactory;
import org.freedesktop.dbus.errors.Error;
import org.freedesktop.dbus.errors.UnknownMethod;
import org.freedesktop.dbus.errors.UnknownObject;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.FatalDBusException;
import org.freedesktop.dbus.exceptions.NotConnected;
import org.freedesktop.dbus.interfaces.CallbackHandler;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.interfaces.Local;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.ExportedObject;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.messages.MethodReturn;
import org.freedesktop.dbus.messages.ObjectTree;
import org.freedesktop.dbus.utils.LoggingHelper;
import org.freedesktop.dbus.utils.NameableThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AbstractConnection
implements Closeable {
    private static final Map<Thread, DBusCallInfo> INFOMAP = new ConcurrentHashMap<Thread, DBusCallInfo>();
    private static final int THREADCOUNT = 4;
    public static final int TCP_CONNECT_TIMEOUT = 100000;
    private static byte endianness = AbstractConnection.getSystemEndianness();
    public static final boolean FLOAT_SUPPORT = null != System.getenv("DBUS_JAVA_FLOATS");
    public static final Pattern BUSNAME_REGEX = Pattern.compile("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$");
    public static final Pattern CONNID_REGEX = Pattern.compile("^:[0-9]*\\.[0-9]*$");
    public static final Pattern OBJECT_REGEX_PATTERN = Pattern.compile("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$");
    public static final Pattern DOLLAR_PATTERN = Pattern.compile("[$]");
    public static final int MAX_ARRAY_LENGTH = 0x4000000;
    public static final int MAX_NAME_LENGTH = 255;
    private final Logger logger;
    private final ObjectTree objectTree;
    private final Map<String, ExportedObject> exportedObjects;
    private final Map<DBusInterface, RemoteObject> importedObjects;
    private final PendingCallbackManager callbackManager;
    private final FallbackContainer fallbackContainer;
    private final Queue<Error> pendingErrorQueue;
    private final Map<SignalTuple, Queue<DBusSigHandler<? extends DBusSignal>>> handledSignals;
    private final Map<SignalTuple, Queue<DBusSigHandler<DBusSignal>>> genericHandledSignals;
    private final Map<Long, MethodCall> pendingCalls;
    private final IncomingMessageThread readerThread;
    private final BusAddress busAddress;
    private final ExecutorService senderService;
    private boolean weakreferences = false;
    private volatile boolean connected = false;
    private AbstractTransport transport;
    private volatile ThreadPoolExecutor workerThreadPool;
    private final ReadWriteLock workerThreadPoolLock = new ReentrantReadWriteLock();

    protected AbstractConnection(String address, int timeout) throws DBusException {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.exportedObjects = new HashMap<String, ExportedObject>();
        this.importedObjects = new ConcurrentHashMap<DBusInterface, RemoteObject>();
        this.exportedObjects.put(null, new ExportedObject(new GlobalHandler(this), this.weakreferences));
        this.handledSignals = new ConcurrentHashMap<SignalTuple, Queue<DBusSigHandler<? extends DBusSignal>>>();
        this.genericHandledSignals = new ConcurrentHashMap<SignalTuple, Queue<DBusSigHandler<DBusSignal>>>();
        this.pendingCalls = Collections.synchronizedMap(new LinkedHashMap());
        this.callbackManager = new PendingCallbackManager();
        this.pendingErrorQueue = new ConcurrentLinkedQueue<Error>();
        this.workerThreadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(4, new NameableThreadFactory("DBus Worker Thread-", false));
        this.senderService = Executors.newFixedThreadPool(1, new NameableThreadFactory("DBus Sender Thread-", false));
        this.objectTree = new ObjectTree();
        this.fallbackContainer = new FallbackContainer();
        this.readerThread = new IncomingMessageThread(this);
        try {
            this.busAddress = new BusAddress(address);
            this.transport = TransportFactory.createTransport(this.busAddress, timeout);
            this.connected = true;
        }
        catch (IOException | DBusException _ex) {
            this.logger.debug("Error creating transport", (Throwable)_ex);
            this.disconnect();
            throw new DBusException("Failed to connect to bus: " + _ex.getMessage(), _ex);
        }
    }

    public abstract DBusInterface getExportedObject(String var1, String var2) throws DBusException;

    protected abstract <T extends DBusSignal> void removeSigHandler(DBusMatchRule var1, DBusSigHandler<T> var2) throws DBusException;

    protected abstract <T extends DBusSignal> void addSigHandler(DBusMatchRule var1, DBusSigHandler<T> var2) throws DBusException;

    protected abstract void removeGenericSigHandler(DBusMatchRule var1, DBusSigHandler<DBusSignal> var2) throws DBusException;

    protected abstract void addGenericSigHandler(DBusMatchRule var1, DBusSigHandler<DBusSignal> var2) throws DBusException;

    public abstract String getMachineId();

    protected void listen() {
        this.readerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeThreadCount(byte _newPoolSize) {
        if (this.workerThreadPool.getMaximumPoolSize() != _newPoolSize) {
            this.workerThreadPoolLock.writeLock().lock();
            try {
                List<Runnable> remainingTasks = this.workerThreadPool.shutdownNow();
                this.workerThreadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(_newPoolSize, new NameableThreadFactory("DbusWorkerThreads", false));
                for (Runnable runnable : remainingTasks) {
                    this.workerThreadPool.execute(runnable);
                }
            }
            finally {
                this.workerThreadPoolLock.writeLock().unlock();
            }
        }
    }

    public String getExportedObject(DBusInterface _interface) throws DBusException {
        String s;
        Optional<Map.Entry> foundInterface = this.getExportedObjects().entrySet().stream().filter(e -> _interface.equals(((ExportedObject)e.getValue()).getObject().get())).findFirst();
        if (foundInterface.isPresent()) {
            return (String)foundInterface.get().getKey();
        }
        RemoteObject rObj = this.getImportedObjects().get(_interface);
        if (rObj != null && (s = rObj.getObjectPath()) != null) {
            return s;
        }
        throw new DBusException("Not an object exported or imported by this connection");
    }

    public void setWeakReferences(boolean _weakreferences) {
        this.weakreferences = _weakreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportObject(String _objectPath, DBusInterface _object) throws DBusException {
        if (null == _objectPath || "".equals(_objectPath)) {
            throw new DBusException("Must Specify an Object Path");
        }
        if (_objectPath.length() > 255 || !OBJECT_REGEX_PATTERN.matcher(_objectPath).matches()) {
            throw new DBusException("Invalid object path: " + _objectPath);
        }
        Map<String, ExportedObject> map = this.getExportedObjects();
        synchronized (map) {
            if (null != this.getExportedObjects().get(_objectPath)) {
                throw new DBusException("Object already exported");
            }
            ExportedObject eo = new ExportedObject(_object, this.weakreferences);
            this.getExportedObjects().put(_objectPath, eo);
            ObjectTree objectTree = this.getObjectTree();
            synchronized (objectTree) {
                this.getObjectTree().add(_objectPath, eo, eo.getIntrospectiondata());
            }
        }
    }

    public void exportObject(DBusInterface _object) throws DBusException {
        Objects.requireNonNull(_object, "object must not be null");
        this.exportObject(_object.getObjectPath(), _object);
    }

    public void addFallback(String _objectPrefix, DBusInterface _object) throws DBusException {
        if (null == _objectPrefix || "".equals(_objectPrefix)) {
            throw new DBusException("Must Specify an Object Path");
        }
        if (_objectPrefix.length() > 255 || !OBJECT_REGEX_PATTERN.matcher(_objectPrefix).matches()) {
            throw new DBusException("Invalid object path: " + _objectPrefix);
        }
        ExportedObject eo = new ExportedObject(_object, this.weakreferences);
        this.fallbackContainer.add(_objectPrefix, eo);
    }

    public void removeFallback(String _objectprefix) {
        this.fallbackContainer.remove(_objectprefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unExportObject(String _objectpath) {
        Map<String, ExportedObject> map = this.getExportedObjects();
        synchronized (map) {
            this.getExportedObjects().remove(_objectpath);
            this.getObjectTree().remove(_objectpath);
        }
    }

    public void sendMessage(final Message _message) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AbstractConnection.this.sendMessageInternally(_message);
            }
        };
        this.senderService.execute(runnable);
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> _type, DBusSigHandler<T> _handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(_type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        this.removeSigHandler(new DBusMatchRule(_type), _handler);
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> _type, DBusInterface _object, DBusSigHandler<T> _handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(_type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        String objectpath = this.getImportedObjects().get(_object).getObjectPath();
        if (objectpath.length() > 255 || !OBJECT_REGEX_PATTERN.matcher(objectpath).matches()) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        this.removeSigHandler(new DBusMatchRule(_type, null, objectpath), _handler);
    }

    public <T extends DBusSignal> void addSigHandler(Class<T> _type, DBusSigHandler<T> _handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(_type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        this.addSigHandler(new DBusMatchRule(_type), _handler);
    }

    public <T extends DBusSignal> void addSigHandler(Class<T> _type, DBusInterface _object, DBusSigHandler<T> _handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(_type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        RemoteObject rObj = this.getImportedObjects().get(_object);
        if (rObj == null) {
            throw new DBusException("Not an object exported or imported by this connection");
        }
        String objectpath = rObj.getObjectPath();
        if (objectpath.length() > 255 || !OBJECT_REGEX_PATTERN.matcher(objectpath).matches()) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        this.addSigHandler(new DBusMatchRule(_type, null, objectpath), _handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends DBusSignal> void addSigHandlerWithoutMatch(Class<? extends DBusSignal> signal, DBusSigHandler<T> handler) throws DBusException {
        DBusMatchRule rule = new DBusMatchRule(signal);
        SignalTuple key = new SignalTuple(rule.getInterface(), rule.getMember(), rule.getObject(), rule.getSource());
        Map<SignalTuple, Queue<DBusSigHandler<? extends DBusSignal>>> map = this.getHandledSignals();
        synchronized (map) {
            Queue<DBusSigHandler<? extends DBusSignal>> v = this.getHandledSignals().get(key);
            if (null == v) {
                v = new ConcurrentLinkedQueue<DBusSigHandler<? extends DBusSignal>>();
                v.add(handler);
                this.getHandledSignals().put(key, v);
            } else {
                v.add(handler);
            }
        }
    }

    protected synchronized void disconnect(IDisconnectAction _before, IDisconnectAction _after) {
        if (_before != null) {
            _before.perform();
        }
        this.internalDisconnect();
        if (_after != null) {
            _after.perform();
        }
    }

    private synchronized void internalDisconnect() {
        if (!this.connected) {
            this.logger.debug("Ignoring disconnect, already disconnected");
            return;
        }
        this.connected = false;
        this.logger.debug("Sending disconnected signal");
        try {
            this.handleMessage(new Local.Disconnected("/"), false);
        }
        catch (Exception ex) {
            this.logger.debug("Exception while disconnecting", (Throwable)ex);
        }
        this.logger.debug("Disconnecting Abstract Connection");
        this.readerThread.terminate();
        this.workerThreadPoolLock.writeLock().lock();
        try {
            this.workerThreadPool.shutdown();
            this.workerThreadPool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException _ex) {
            this.logger.debug("Interrupted while waiting for worker threads to be terminated.", (Throwable)_ex);
        }
        finally {
            this.workerThreadPoolLock.writeLock().unlock();
        }
        for (Runnable runnable : this.senderService.shutdownNow()) {
            runnable.run();
        }
        try {
            if (this.transport != null) {
                this.transport.close();
                this.transport = null;
            }
        }
        catch (IOException exIo) {
            this.logger.debug("Exception while disconnecting transport.", (Throwable)exIo);
        }
        this.workerThreadPoolLock.writeLock().lock();
        try {
            if (!this.workerThreadPool.isTerminated()) {
                this.workerThreadPool.shutdownNow();
            }
        }
        finally {
            this.workerThreadPoolLock.writeLock().unlock();
        }
    }

    public synchronized void disconnect() {
        this.internalDisconnect();
    }

    @Override
    public void close() throws IOException {
        this.disconnect();
    }

    public <A> void callWithCallback(DBusInterface object, String m, CallbackHandler<A> callback, Object ... parameters) {
        this.logger.trace("callWithCallback({}, {}, {})", new Object[]{object, m, callback});
        Class<?>[] types = this.createTypesArray(parameters);
        RemoteObject ro = this.getImportedObjects().get(object);
        try {
            Method me = null == ro.getInterface() ? object.getClass().getMethod(m, types) : ro.getInterface().getMethod(m, types);
            RemoteInvocationHandler.executeRemoteMethod(ro, me, this, 2, callback, parameters);
        }
        catch (DBusExecutionException exEe) {
            this.logger.debug("", (Throwable)exEe);
            throw exEe;
        }
        catch (Exception e) {
            this.logger.debug("", (Throwable)e);
            throw new DBusExecutionException(e.getMessage());
        }
    }

    public DBusAsyncReply<?> callMethodAsync(DBusInterface _object, String _method, Object ... _parameters) {
        Class<?>[] types = this.createTypesArray(_parameters);
        RemoteObject ro = this.getImportedObjects().get(_object);
        try {
            Method me = null == ro.getInterface() ? _object.getClass().getMethod(_method, types) : ro.getInterface().getMethod(_method, types);
            return (DBusAsyncReply)RemoteInvocationHandler.executeRemoteMethod(ro, me, this, 1, null, _parameters);
        }
        catch (DBusExecutionException exDee) {
            this.logger.debug("", (Throwable)exDee);
            throw exDee;
        }
        catch (Exception e) {
            this.logger.debug("", (Throwable)e);
            throw new DBusExecutionException(e.getMessage());
        }
    }

    private Class<?>[] createTypesArray(Object ... parameters) {
        if (parameters == null) {
            return null;
        }
        return (Class[])Arrays.stream(parameters).filter(p -> p != null).map(p -> {
            if (List.class.isAssignableFrom(p.getClass())) {
                return List.class;
            }
            if (Map.class.isAssignableFrom(p.getClass())) {
                return Map.class;
            }
            if (Set.class.isAssignableFrom(p.getClass())) {
                return Set.class;
            }
            return p.getClass();
        }).toArray(Class[]::new);
    }

    protected void handleException(AbstractConnection _dbusConnection, Message _methodOrSignal, DBusExecutionException _exception) {
        if (_dbusConnection == null) {
            throw new NullPointerException("DBusConnection cannot be null");
        }
        try {
            _dbusConnection.sendMessage(new Error(_methodOrSignal, _exception));
        }
        catch (DBusException ex) {
            this.logger.warn("Exception caught while processing previous error.", (Throwable)ex);
        }
    }

    void handleMessage(Message _message) throws DBusException {
        if (_message instanceof DBusSignal) {
            this.handleMessage((DBusSignal)_message, true);
        } else if (_message instanceof MethodCall) {
            this.handleMessage((MethodCall)_message);
        } else if (_message instanceof MethodReturn) {
            this.handleMessage((MethodReturn)_message);
        } else if (_message instanceof Error) {
            this.handleMessage((Error)_message);
        }
    }

    private void handleMessage(final MethodCall _methodCall) throws DBusException {
        this.logger.debug("Handling incoming method call: {}", (Object)_methodCall);
        ExportedObject eo = null;
        Method meth = null;
        DBusInterface o = null;
        if (null == _methodCall.getInterface() || _methodCall.getInterface().equals("org.freedesktop.DBus.Peer") || _methodCall.getInterface().equals("org.freedesktop.DBus.Introspectable")) {
            eo = this.getExportedObjects().get(null);
            if (null != eo && null == eo.getObject().get()) {
                this.unExportObject(null);
                eo = null;
            }
            if (null != eo) {
                meth = eo.getMethods().get(new MethodTuple(_methodCall.getName(), _methodCall.getSig()));
            }
            if (null != meth) {
                o = new GlobalHandler(this, _methodCall.getPath());
            } else {
                eo = null;
            }
        }
        if (null == o) {
            eo = this.getExportedObjects().get(_methodCall.getPath());
            if (null != eo && null == eo.getObject().get()) {
                this.logger.info("Unexporting {} implicitly", (Object)_methodCall.getPath());
                this.unExportObject(_methodCall.getPath());
                eo = null;
            }
            if (null == eo) {
                eo = this.fallbackContainer.get(_methodCall.getPath());
            }
            if (null == eo) {
                this.sendMessage(new Error(_methodCall, new UnknownObject(_methodCall.getPath() + " is not an object provided by this process.")));
                return;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Searching for method {}  with signature {}", (Object)_methodCall.getName(), (Object)_methodCall.getSig());
                this.logger.trace("List of methods on {}: ", (Object)eo);
                for (MethodTuple mt : eo.getMethods().keySet()) {
                    this.logger.trace("   {} => {}", (Object)mt, (Object)eo.getMethods().get(mt));
                }
            }
            if (null == (meth = eo.getMethods().get(new MethodTuple(_methodCall.getName(), _methodCall.getSig())))) {
                this.sendMessage(new Error(_methodCall, new UnknownMethod(String.format("The method `%s.%s' does not exist on this object.", _methodCall.getInterface(), _methodCall.getName()))));
                return;
            }
            o = eo.getObject().get();
        }
        final Method me = meth;
        final GlobalHandler ob = o;
        final boolean noreply = 1 == (_methodCall.getFlags() & 1);
        final DBusCallInfo info = new DBusCallInfo(_methodCall);
        final AbstractConnection conn = this;
        this.logger.trace("Adding Runnable for method {}", (Object)meth);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                AbstractConnection.this.logger.debug("Running method {} for remote call", (Object)me);
                if (me == null) {
                    AbstractConnection.this.logger.debug("Cannot run method - method variable was null");
                    return;
                }
                try {
                    Object[] ts = me.getGenericParameterTypes();
                    _methodCall.setArgs(Marshalling.deSerializeParameters(_methodCall.getParameters(), (Type[])ts, conn));
                    AbstractConnection.this.logger.trace("Deserialised {} to types {}", (Object)LoggingHelper.arraysDeepString(AbstractConnection.this.logger.isTraceEnabled(), _methodCall.getParameters()), (Object)LoggingHelper.arraysDeepString(AbstractConnection.this.logger.isTraceEnabled(), ts));
                }
                catch (Exception e) {
                    AbstractConnection.this.logger.debug("", (Throwable)e);
                    AbstractConnection.this.handleException(conn, _methodCall, new UnknownMethod("Failure in de-serializing message: " + e));
                    return;
                }
                try {
                    Object result;
                    INFOMAP.put(Thread.currentThread(), info);
                    try {
                        AbstractConnection.this.logger.trace("Invoking Method: {} on {} with parameters {}", new Object[]{me, ob, Arrays.deepToString(_methodCall.getParameters())});
                        result = me.invoke(ob, _methodCall.getParameters());
                    }
                    catch (InvocationTargetException ite) {
                        AbstractConnection.this.logger.debug(ite.getMessage(), (Throwable)ite);
                        throw ite.getCause();
                    }
                    INFOMAP.remove(Thread.currentThread());
                    if (!noreply) {
                        MethodReturn reply;
                        if (Void.TYPE.equals(me.getReturnType())) {
                            reply = new MethodReturn(_methodCall, null, new Object[0]);
                        } else {
                            StringBuffer sb = new StringBuffer();
                            for (String s : Marshalling.getDBusType(me.getGenericReturnType())) {
                                sb.append(s);
                            }
                            Object[] nr = Marshalling.convertParameters(new Object[]{result}, new Type[]{me.getGenericReturnType()}, conn);
                            reply = new MethodReturn(_methodCall, sb.toString(), nr);
                        }
                        conn.sendMessage(reply);
                    }
                }
                catch (DBusExecutionException exDee) {
                    AbstractConnection.this.logger.debug("", (Throwable)exDee);
                    AbstractConnection.this.handleException(conn, _methodCall, exDee);
                }
                catch (Throwable e) {
                    AbstractConnection.this.logger.debug("", e);
                    AbstractConnection.this.handleException(conn, _methodCall, new DBusExecutionException(String.format("Error Executing Method %s.%s: %s", _methodCall.getInterface(), _methodCall.getName(), e.getMessage())));
                }
            }
        };
        this.executeInWorkerThreadPool(r);
    }

    private void handleMessage(final DBusSignal _signal, boolean _useThreadPool) {
        Runnable command;
        this.logger.debug("Handling incoming signal: {}", (Object)_signal);
        ArrayList<DBusSigHandler<? extends DBusSignal>> handlers = new ArrayList<DBusSigHandler<? extends DBusSignal>>();
        ArrayList<DBusSigHandler<DBusSignal>> genericHandlers = new ArrayList<DBusSigHandler<DBusSignal>>();
        Queue<DBusSigHandler<? extends DBusSignal>> t = this.getHandledSignals().get(new SignalTuple(_signal.getInterface(), _signal.getName(), null, null));
        if (null != t) {
            handlers.addAll(t);
        }
        if (null != (t = this.getHandledSignals().get(new SignalTuple(_signal.getInterface(), _signal.getName(), _signal.getPath(), null)))) {
            handlers.addAll(t);
        }
        if (null != (t = this.getHandledSignals().get(new SignalTuple(_signal.getInterface(), _signal.getName(), null, _signal.getSource())))) {
            handlers.addAll(t);
        }
        if (null != (t = this.getHandledSignals().get(new SignalTuple(_signal.getInterface(), _signal.getName(), _signal.getPath(), _signal.getSource())))) {
            handlers.addAll(t);
        }
        Set<SignalTuple> allTuples = SignalTuple.getAllPossibleTuples(_signal.getInterface(), _signal.getName(), _signal.getPath(), _signal.getSource());
        for (SignalTuple tuple : allTuples) {
            Queue<DBusSigHandler<DBusSignal>> gt = this.getGenericHandledSignals().get(tuple);
            if (null == gt) continue;
            genericHandlers.addAll(gt);
        }
        if (handlers.isEmpty() && genericHandlers.isEmpty()) {
            return;
        }
        final AbstractConnection conn = this;
        for (final DBusSigHandler dBusSigHandler : handlers) {
            this.logger.trace("Adding Runnable for signal {} with handler {}", (Object)_signal, (Object)dBusSigHandler);
            command = new Runnable(){

                @Override
                public void run() {
                    try {
                        DBusSignal rs = _signal instanceof InternalSignal || _signal.getClass().equals(DBusSignal.class) ? _signal.createReal(conn) : _signal;
                        if (rs == null) {
                            return;
                        }
                        dBusSigHandler.handle(rs);
                    }
                    catch (DBusException _ex) {
                        AbstractConnection.this.logger.warn("Exception while running signal handler '{}' for signal '{}':", new Object[]{dBusSigHandler, _signal, _ex});
                        AbstractConnection.this.handleException(conn, _signal, new DBusExecutionException("Error handling signal " + _signal.getInterface() + "." + _signal.getName() + ": " + _ex.getMessage()));
                    }
                }
            };
            if (_useThreadPool) {
                this.executeInWorkerThreadPool(command);
                continue;
            }
            command.run();
        }
        for (final DBusSigHandler dBusSigHandler : genericHandlers) {
            this.logger.trace("Adding Runnable for signal {} with handler {}", (Object)_signal, (Object)dBusSigHandler);
            command = new Runnable(){

                @Override
                public void run() {
                    dBusSigHandler.handle(_signal);
                }
            };
            if (_useThreadPool) {
                this.executeInWorkerThreadPool(command);
                continue;
            }
            command.run();
        }
    }

    private void executeInWorkerThreadPool(Runnable _task) {
        this.workerThreadPoolLock.readLock().lock();
        try {
            this.workerThreadPool.execute(_task);
        }
        finally {
            this.workerThreadPoolLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(final Error _err) {
        this.logger.debug("Handling incoming error: {}", (Object)_err);
        MethodCall m = null;
        if (this.getPendingCalls() == null) {
            return;
        }
        Map<Long, MethodCall> map = this.getPendingCalls();
        synchronized (map) {
            if (this.getPendingCalls().containsKey(_err.getReplySerial())) {
                m = this.getPendingCalls().remove(_err.getReplySerial());
            }
        }
        if (m != null) {
            m.setReply(_err);
            CallbackHandler<? extends Object> cbh = null;
            cbh = this.callbackManager.removeCallback(m);
            this.logger.trace("{} = pendingCallbacks.remove({})", cbh, (Object)m);
            if (null != cbh) {
                final CallbackHandler<? extends Object> fcbh = cbh;
                this.logger.trace("Adding Error Runnable with callback handler {}", fcbh);
                Runnable command = new Runnable(){

                    @Override
                    public synchronized void run() {
                        try {
                            AbstractConnection.this.logger.trace("Running Error Callback for {}", (Object)_err);
                            DBusCallInfo info = new DBusCallInfo(_err);
                            INFOMAP.put(Thread.currentThread(), info);
                            fcbh.handleError(_err.getException());
                            INFOMAP.remove(Thread.currentThread());
                        }
                        catch (Exception e) {
                            AbstractConnection.this.logger.debug("Exception while running error callback.", (Throwable)e);
                        }
                    }
                };
                this.executeInWorkerThreadPool(command);
            }
        } else {
            this.getPendingErrorQueue().add(_err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(final MethodReturn _mr) {
        this.logger.debug("Handling incoming method return: {}", (Object)_mr);
        MethodCall m = null;
        if (null == this.getPendingCalls()) {
            return;
        }
        Map<Long, MethodCall> map = this.getPendingCalls();
        synchronized (map) {
            if (this.getPendingCalls().containsKey(_mr.getReplySerial())) {
                m = this.getPendingCalls().remove(_mr.getReplySerial());
            }
        }
        if (null != m) {
            m.setReply(_mr);
            _mr.setCall(m);
            CallbackHandler<? extends Object> cbh = this.callbackManager.getCallback(m);
            DBusAsyncReply<?> asr = this.callbackManager.getCallbackReply(m);
            this.callbackManager.removeCallback(m);
            if (null != cbh) {
                final CallbackHandler<? extends Object> fcbh = cbh;
                final DBusAsyncReply<?> fasr = asr;
                if (fasr == null) {
                    this.logger.debug("Cannot add runnable for method, given method callback was null");
                    return;
                }
                this.logger.trace("Adding Runnable for method {} with callback handler {}", fcbh, (Object)(fasr != null ? fasr.getMethod() : null));
                Runnable r = new Runnable(){

                    @Override
                    public synchronized void run() {
                        try {
                            AbstractConnection.this.logger.trace("Running Callback for {}", (Object)_mr);
                            DBusCallInfo info = new DBusCallInfo(_mr);
                            INFOMAP.put(Thread.currentThread(), info);
                            Object convertRV = RemoteInvocationHandler.convertRV(_mr.getSig(), _mr.getParameters(), fasr.getMethod(), fasr.getConnection());
                            fcbh.handle(convertRV);
                            INFOMAP.remove(Thread.currentThread());
                        }
                        catch (Exception e) {
                            AbstractConnection.this.logger.debug("Exception while running callback.", (Throwable)e);
                        }
                    }
                };
                this.executeInWorkerThreadPool(r);
            }
        } else {
            try {
                this.sendMessage(new Error(_mr, new DBusExecutionException("Spurious reply. No message with the given serial id was awaiting a reply.")));
            }
            catch (DBusException dBusException) {
                // empty catch block
            }
        }
    }

    public void queueCallback(MethodCall _call, Method _method, CallbackHandler<?> _callback) {
        this.callbackManager.queueCallback(_call, _method, _callback, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessageInternally(Message _message) {
        block26: {
            try {
                if (!this.connected) {
                    throw new NotConnected("Disconnected");
                }
                if (_message instanceof DBusSignal) {
                    ((DBusSignal)_message).appendbody(this);
                }
                if (_message instanceof MethodCall && 0 == (_message.getFlags() & 1)) {
                    if (null == this.getPendingCalls()) {
                        ((MethodCall)_message).setReply(new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.Disconnected", 0L, "s", "Disconnected"));
                    } else {
                        Map<Long, MethodCall> map = this.getPendingCalls();
                        synchronized (map) {
                            this.getPendingCalls().put(_message.getSerial(), (MethodCall)_message);
                        }
                    }
                }
                this.transport.writeMessage(_message);
            }
            catch (Exception e) {
                this.logger.debug("Exception while sending message.", (Throwable)e);
                if (_message instanceof MethodCall && e instanceof NotConnected) {
                    try {
                        ((MethodCall)_message).setReply(new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.Disconnected", 0L, "s", "Disconnected"));
                    }
                    catch (DBusException dBusException) {
                        // empty catch block
                    }
                }
                if (_message instanceof MethodCall && e instanceof DBusExecutionException) {
                    try {
                        ((MethodCall)_message).setReply(new Error(_message, e));
                    }
                    catch (DBusException dBusException) {}
                } else if (_message instanceof MethodCall) {
                    try {
                        this.logger.info("Setting reply to {} as an error", (Object)_message);
                        ((MethodCall)_message).setReply(new Error(_message, new DBusExecutionException("Message Failed to Send: " + e.getMessage())));
                    }
                    catch (DBusException dBusException) {}
                } else if (_message instanceof MethodReturn) {
                    try {
                        this.transport.writeMessage(new Error(_message, e));
                    }
                    catch (IOException exIo) {
                        this.logger.debug("", (Throwable)exIo);
                    }
                    catch (DBusException exDe) {
                        this.logger.debug("", (Throwable)exDe);
                    }
                }
                if (!(e instanceof IOException)) break block26;
                this.disconnect();
            }
        }
    }

    Message readIncoming() throws DBusException {
        Message m;
        block4: {
            if (!this.connected) {
                return null;
            }
            m = null;
            try {
                m = this.transport.readMessage();
            }
            catch (IOException exIo) {
                if (!this.connected && exIo instanceof EOFException) {
                    return null;
                }
                if (!this.connected) break block4;
                throw new FatalDBusException(exIo.getMessage());
            }
        }
        return m;
    }

    protected Map<String, ExportedObject> getExportedObjects() {
        return this.exportedObjects;
    }

    FallbackContainer getFallbackContainer() {
        return this.fallbackContainer;
    }

    public static DBusCallInfo getCallInfo() {
        return INFOMAP.get(Thread.currentThread());
    }

    public DBusExecutionException getError() {
        Error poll = this.getPendingErrorQueue().poll();
        if (poll != null) {
            return poll.getException();
        }
        return null;
    }

    public BusAddress getAddress() {
        return this.busAddress;
    }

    public boolean isConnected() {
        return this.connected;
    }

    protected Queue<Error> getPendingErrorQueue() {
        return this.pendingErrorQueue;
    }

    protected Map<SignalTuple, Queue<DBusSigHandler<? extends DBusSignal>>> getHandledSignals() {
        return this.handledSignals;
    }

    protected Map<SignalTuple, Queue<DBusSigHandler<DBusSignal>>> getGenericHandledSignals() {
        return this.genericHandledSignals;
    }

    protected Map<Long, MethodCall> getPendingCalls() {
        return this.pendingCalls;
    }

    protected Map<DBusInterface, RemoteObject> getImportedObjects() {
        return this.importedObjects;
    }

    protected ObjectTree getObjectTree() {
        return this.objectTree;
    }

    public static void setEndianness(byte _b) {
        if (_b == 66 || _b == 108) {
            endianness = _b;
        }
    }

    public static byte getEndianness() {
        return endianness;
    }

    public static byte getSystemEndianness() {
        return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? (byte)66 : 108;
    }
}

