/*
 * Decompiled with CFR 0.152.
 */
package ca.sineware.prolinuxd;

import ca.sineware.prolinuxd.CloudClient;
import ca.sineware.prolinuxd.dbus.DbusClient;
import ca.sineware.prolinuxd.installer.OSInstaller;
import ca.sineware.prolinuxd.phoneos.PlasmaMobile;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.ini4j.Ini;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    public static Ini baseSysConf;
    public static Ini sysConf;
    public static String cloudToken;
    public static String mode;

    public static void main(String[] args) throws Exception {
        log.info("Starting prolinuxd on " + System.getProperty("os.name") + "...");
        OperatingSystemMXBean bean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        log.info(bean.getArch());
        log.info(bean.getName());
        log.info(bean.getVersion());
        log.info(String.valueOf(bean.getTotalMemorySize()));
        log.info(String.valueOf(bean.getSystemLoadAverage()));
        log.info("Attempting connection to D-Bus...");
        try {
            DbusClient.connectDbus();
        }
        catch (Exception e) {
            log.error("Could not connect to D-Bus!");
            e.printStackTrace();
            System.exit(-1);
        }
        log.info("Reading base system configuration file...");
        try {
            baseSysConf = new Ini(new File("/sineware.ini"));
        }
        catch (Exception e) {
            log.error("Could not read system configuration!");
            e.printStackTrace();
            System.exit(-2);
        }
        String systemStyle = baseSysConf.get((Object)"prolinux", (Object)"style");
        log.info("System style: " + systemStyle);
        if ("live".equals(systemStyle)) {
            OSInstaller oSInstaller = new OSInstaller();
        } else if ("system".equals(systemStyle)) {
            Path path = Paths.get("/config/prolinux.ini", new String[0]);
            if (System.getenv("SINEWARE_CLOUD_TOKEN") != null && !System.getenv("SINEWARE_CLOUD_TOKEN").isBlank()) {
                cloudToken = System.getenv("SINEWARE_CLOUD_TOKEN");
            } else if (Files.exists(path, new LinkOption[0])) {
                log.info("Reading system ProLinux configuration...");
                sysConf = new Ini(new File("/config/prolinux.ini"));
                cloudToken = sysConf.get((Object)"prolinux", (Object)"cloud_token");
            }
            if (cloudToken != null) {
                log.info("Attempting to connect to Sineware Cloud Services...");
                mode = "cloud";
                CloudClient client = new CloudClient(new URI("wss://update.sineware.ca/api/v1/gateway"));
                client.connect();
            } else {
                log.info("Booting in standalone mode...");
                mode = "standalone";
                log.info("Starting Plasma Mobile...");
                PlasmaMobile pm = new PlasmaMobile();
                pm.startKwinWrapper();
            }
        } else if ("pmsdk".equals(systemStyle)) {
            log.info("Booting in PM SDK mode...");
            mode = "pmsdk";
        } else {
            log.error("Unknown or not set System style.");
            System.exit(-4);
        }
    }
}

