/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.errors;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.MessageFormatException;
import org.freedesktop.dbus.exceptions.NotConnected;
import org.freedesktop.dbus.messages.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Error
extends Message {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Error() {
    }

    public Error(String dest, String errorName, long replyserial, String sig, Object ... args) throws DBusException {
        this(null, dest, errorName, replyserial, sig, args);
    }

    public Error(String source, String dest, String errorName, long replyserial, String sig, Object ... args) throws DBusException {
        super(DBusConnection.getEndianness(), (byte)3, (byte)0);
        if (null == errorName) {
            throw new MessageFormatException("Must specify error name to Errors.");
        }
        this.getHeaders().put((byte)5, replyserial);
        this.getHeaders().put((byte)4, errorName);
        ArrayList<Object[]> hargs = new ArrayList<Object[]>();
        hargs.add(new Object[]{(byte)4, new Object[]{"s", errorName}});
        hargs.add(new Object[]{(byte)5, new Object[]{"u", replyserial}});
        if (null != source) {
            this.getHeaders().put((byte)7, source);
            hargs.add(new Object[]{(byte)7, new Object[]{"s", source}});
        }
        if (null != dest) {
            this.getHeaders().put((byte)6, dest);
            hargs.add(new Object[]{(byte)6, new Object[]{"s", dest}});
        }
        if (null != sig) {
            hargs.add(new Object[]{(byte)8, new Object[]{"g", sig}});
            this.getHeaders().put((byte)8, sig);
            this.setArgs(args);
        }
        byte[] blen = new byte[4];
        this.appendBytes(blen);
        this.append("ua(yv)", this.getSerial(), hargs.toArray());
        this.pad((byte)8);
        long c = this.getByteCounter();
        if (null != sig) {
            this.append(sig, args);
        }
        this.marshallint(this.getByteCounter() - c, blen, 0, 4);
    }

    public Error(String source, Message m, Throwable e) throws DBusException {
        this(source, m.getSource(), AbstractConnection.DOLLAR_PATTERN.matcher(e.getClass().getName()).replaceAll("."), m.getSerial(), "s", e.getMessage());
    }

    public Error(Message m, Throwable e) throws DBusException {
        this(m.getSource(), AbstractConnection.DOLLAR_PATTERN.matcher(e.getClass().getName()).replaceAll("."), m.getSerial(), "s", e.getMessage());
    }

    private static Class<? extends DBusExecutionException> createExceptionClass(String name) {
        if ("org.freedesktop.DBus.Local.Disconnected".equals(name)) {
            return NotConnected.class;
        }
        Class<?> c = null;
        if (name.startsWith("org.freedesktop.DBus.Error.")) {
            name = name.replace("org.freedesktop.DBus.Error.", "org.freedesktop.dbus.errors.");
        }
        do {
            try {
                c = Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            name = name.replaceAll("\\.([^\\.]*)$", "\\$$1");
        } while (null == c && name.matches(".*\\..*"));
        return c;
    }

    public DBusExecutionException getException() {
        try {
            DBusExecutionException ex;
            Class<? extends DBusExecutionException> c = Error.createExceptionClass(this.getName());
            if (null == c || !DBusExecutionException.class.isAssignableFrom(c)) {
                c = DBusExecutionException.class;
            }
            Constructor<? extends DBusExecutionException> con = c.getConstructor(String.class);
            Object[] args2 = this.getParameters();
            if (null == args2 || 0 == args2.length) {
                ex = con.newInstance("");
            } else {
                String s = "";
                for (Object o : args2) {
                    s = s + o + " ";
                }
                ex = con.newInstance(s.trim());
            }
            ex.setType(this.getName());
            return ex;
        }
        catch (Exception ex1) {
            DBusExecutionException ex;
            this.logger.debug("", (Throwable)ex1);
            Object[] args = null;
            try {
                args = this.getParameters();
            }
            catch (Exception args2) {
                // empty catch block
            }
            if (null == args || 0 == args.length) {
                ex = new DBusExecutionException("");
            } else {
                String s = "";
                for (Object o : args) {
                    s = s + o + " ";
                }
                ex = new DBusExecutionException(s.trim());
            }
            ex.setType(this.getName());
            return ex;
        }
    }

    public void throwException() throws DBusExecutionException {
        throw this.getException();
    }
}

