/*
 * Decompiled with CFR 0.152.
 */
package ca.sineware.prolinuxd.gui.installer;

import ca.sineware.prolinuxd.gui.SwingAppender;
import ca.sineware.prolinuxd.gui.installer.InstallType;
import ca.sineware.prolinuxd.gui.installer.TextFieldWithLabel;
import ca.sineware.prolinuxd.installer.InstallerConfig;
import ca.sineware.prolinuxd.installer.OSInstaller;
import com.formdev.flatlaf.FlatLightLaf;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallerGUI
extends JFrame {
    private static final Logger log = LoggerFactory.getLogger(InstallerGUI.class);
    InstallType installType = InstallType.ENTIRE_DISK;

    public InstallerGUI() throws Exception {
        FlatLightLaf.setup();
        JPanel contents = new JPanel();
        contents.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridy = 0;
        JLabel titleText = new JLabel();
        titleText.setText("Sineware ProLinux Installer");
        titleText.setFont(new Font("Sans", 0, 32));
        contents.add((Component)titleText, c);
        ++c.gridy;
        JLabel instructionsText = new JLabel();
        instructionsText.setText("Welcome to the Sineware ProLinux (In Development) Installer! Not for production use.");
        contents.add((Component)instructionsText, c);
        ++c.gridy;
        JPanel sysTypePanel = new JPanel();
        sysTypePanel.setLayout(new FlowLayout());
        JRadioButton entireButton = new JRadioButton("Use Entire Disk", true);
        JRadioButton customButton = new JRadioButton("Custom Scheme");
        ButtonGroup sysTypeGroup = new ButtonGroup();
        sysTypeGroup.add(entireButton);
        sysTypeGroup.add(customButton);
        sysTypePanel.add(entireButton);
        sysTypePanel.add(customButton);
        contents.add((Component)sysTypePanel, c);
        ++c.gridy;
        TextFieldWithLabel targetDisk = new TextFieldWithLabel("Target disk (ex. /dev/sda)");
        contents.add((Component)targetDisk.getPanel(), c);
        ++c.gridy;
        TextFieldWithLabel bootPartition = new TextFieldWithLabel("Boot partition/disk (ex. /dev/sda1)");
        contents.add((Component)bootPartition.getPanel(), c);
        ++c.gridy;
        TextFieldWithLabel rootPartition = new TextFieldWithLabel("Root partition/disk (ex. /dev/sda2)");
        contents.add((Component)rootPartition.getPanel(), c);
        ++c.gridy;
        contents.add((Component)new JSeparator(0), c);
        ++c.gridy;
        TextFieldWithLabel cloudUsername = new TextFieldWithLabel("Sineware Cloud Username");
        contents.add((Component)cloudUsername.getPanel(), c);
        ++c.gridy;
        TextFieldWithLabel cloudPassword = new TextFieldWithLabel("Sineware Cloud Password");
        contents.add((Component)cloudPassword.getPanel(), c);
        ++c.gridy;
        TextFieldWithLabel hostname = new TextFieldWithLabel("Device Hostname (a-b, 1-9, _, -)");
        contents.add((Component)hostname.getPanel(), c);
        ++c.gridy;
        contents.add((Component)new JSeparator(0), c);
        ++c.gridy;
        JButton installButton = new JButton("Install");
        contents.add((Component)installButton, c);
        ++c.gridy;
        contents.add((Component)new JSeparator(0), c);
        ++c.gridy;
        contents.add((Component)new JLabel("Logs"), c);
        ++c.gridy;
        SwingAppender.logArea = new JTextArea(15, 45);
        SwingAppender.logScrollPane = new JScrollPane(SwingAppender.logArea, 22, 32);
        SwingAppender.logScrollPane.setPreferredSize(new Dimension(100, 200));
        contents.add((Component)SwingAppender.logScrollPane, c);
        bootPartition.getPanel().setVisible(false);
        rootPartition.getPanel().setVisible(false);
        this.add(contents);
        SwingUtilities.updateComponentTreeUI(this);
        this.pack();
        entireButton.addActionListener(e -> {
            bootPartition.getPanel().setVisible(false);
            rootPartition.getPanel().setVisible(false);
            this.installType = InstallType.ENTIRE_DISK;
        });
        customButton.addActionListener(e -> {
            bootPartition.getPanel().setVisible(true);
            rootPartition.getPanel().setVisible(true);
            this.installType = InstallType.CUSTOM_SCHEME;
        });
        installButton.addActionListener(e -> {
            log.info("Starting install...");
            InstallerConfig conf = new InstallerConfig();
            conf.targetDisk = targetDisk.getText();
            conf.hostname = hostname.getText();
            try {
                new Thread(() -> {
                    try {
                        log.info("Starting OSInstaller.installOS in thread...");
                        OSInstaller.installOS(conf);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(this, ex.getMessage());
                    }
                }).start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, ex.getMessage());
            }
        });
        this.setSize(900, 700);
        this.setVisible(true);
    }
}

