# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide6.QtGraphs, except for defaults which are replaced by "...".
"""

# Module `PySide6.QtGraphs`

import PySide6.QtGraphs
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtQml
import PySide6.QtQuick
import PySide6.QtQuickWidgets

import os
import enum
from typing import Any, ClassVar, List, Match, Optional, Sequence, Set, Tuple, Type, Union, overload
from PySide6.QtCore import Signal
from shiboken6 import Shiboken
from typing import TypeAlias, TypeVar


NoneType: TypeAlias = type[None]
PlaceHolderType = TypeVar("PlaceHolderType", bound=QObject)


class Q3DBars(PySide6.QtGraphs.QAbstract3DGraph):

    barSeriesMarginChanged   : ClassVar[Signal] = ... # barSeriesMarginChanged(QSizeF)
    barSpacingChanged        : ClassVar[Signal] = ... # barSpacingChanged(QSizeF)
    barSpacingRelativeChanged: ClassVar[Signal] = ... # barSpacingRelativeChanged(bool)
    barThicknessChanged      : ClassVar[Signal] = ... # barThicknessChanged(float)
    columnAxisChanged        : ClassVar[Signal] = ... # columnAxisChanged(QCategory3DAxis*)
    floorLevelChanged        : ClassVar[Signal] = ... # floorLevelChanged(float)
    multiSeriesUniformChanged: ClassVar[Signal] = ... # multiSeriesUniformChanged(bool)
    primarySeriesChanged     : ClassVar[Signal] = ... # primarySeriesChanged(QBar3DSeries*)
    rowAxisChanged           : ClassVar[Signal] = ... # rowAxisChanged(QCategory3DAxis*)
    selectedSeriesChanged    : ClassVar[Signal] = ... # selectedSeriesChanged(QBar3DSeries*)
    valueAxisChanged         : ClassVar[Signal] = ... # valueAxisChanged(QValue3DAxis*)

    def __init__(self) -> None: ...

    def addAxis(self, axis: PySide6.QtGraphs.QAbstract3DAxis) -> None: ...
    def addSeries(self, series: PySide6.QtGraphs.QBar3DSeries) -> None: ...
    def axes(self) -> List[PySide6.QtGraphs.QAbstract3DAxis]: ...
    def barSeriesMargin(self) -> PySide6.QtCore.QSizeF: ...
    def barSpacing(self) -> PySide6.QtCore.QSizeF: ...
    def barThickness(self) -> float: ...
    def columnAxis(self) -> PySide6.QtGraphs.QCategory3DAxis: ...
    def floorLevel(self) -> float: ...
    def insertSeries(self, index: int, series: PySide6.QtGraphs.QBar3DSeries) -> None: ...
    def isBarSpacingRelative(self) -> bool: ...
    def isMultiSeriesUniform(self) -> bool: ...
    def primarySeries(self) -> PySide6.QtGraphs.QBar3DSeries: ...
    def releaseAxis(self, axis: PySide6.QtGraphs.QAbstract3DAxis) -> None: ...
    def removeSeries(self, series: PySide6.QtGraphs.QBar3DSeries) -> None: ...
    def rowAxis(self) -> PySide6.QtGraphs.QCategory3DAxis: ...
    def selectedSeries(self) -> PySide6.QtGraphs.QBar3DSeries: ...
    def seriesList(self) -> List[PySide6.QtGraphs.QBar3DSeries]: ...
    def setBarSeriesMargin(self, margin: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]) -> None: ...
    def setBarSpacing(self, spacing: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]) -> None: ...
    def setBarSpacingRelative(self, relative: bool) -> None: ...
    def setBarThickness(self, thicknessRatio: float) -> None: ...
    def setColumnAxis(self, axis: PySide6.QtGraphs.QCategory3DAxis) -> None: ...
    def setFloorLevel(self, level: float) -> None: ...
    def setMultiSeriesUniform(self, uniform: bool) -> None: ...
    def setPrimarySeries(self, series: PySide6.QtGraphs.QBar3DSeries) -> None: ...
    def setRowAxis(self, axis: PySide6.QtGraphs.QCategory3DAxis) -> None: ...
    def setValueAxis(self, axis: PySide6.QtGraphs.QValue3DAxis) -> None: ...
    def valueAxis(self) -> PySide6.QtGraphs.QValue3DAxis: ...


class Q3DInputHandler(PySide6.QtGraphs.QAbstract3DInputHandler):

    rotationEnabledChanged   : ClassVar[Signal] = ... # rotationEnabledChanged(bool)
    selectionEnabledChanged  : ClassVar[Signal] = ... # selectionEnabledChanged(bool)
    zoomAtTargetEnabledChanged: ClassVar[Signal] = ... # zoomAtTargetEnabledChanged(bool)
    zoomEnabledChanged       : ClassVar[Signal] = ... # zoomEnabledChanged(bool)

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def isRotationEnabled(self) -> bool: ...
    def isSelectionEnabled(self) -> bool: ...
    def isZoomAtTargetEnabled(self) -> bool: ...
    def isZoomEnabled(self) -> bool: ...
    def mouseMoveEvent(self, event: PySide6.QtGui.QMouseEvent, mousePos: PySide6.QtCore.QPoint) -> None: ...
    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent, mousePos: PySide6.QtCore.QPoint) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtGui.QMouseEvent, mousePos: PySide6.QtCore.QPoint) -> None: ...
    def setRotationEnabled(self, enable: bool) -> None: ...
    def setSelectionEnabled(self, enable: bool) -> None: ...
    def setZoomAtTargetEnabled(self, enable: bool) -> None: ...
    def setZoomEnabled(self, enable: bool) -> None: ...
    def wheelEvent(self, event: PySide6.QtGui.QWheelEvent) -> None: ...


class Q3DScatter(PySide6.QtGraphs.QAbstract3DGraph):

    axisXChanged             : ClassVar[Signal] = ... # axisXChanged(QValue3DAxis*)
    axisYChanged             : ClassVar[Signal] = ... # axisYChanged(QValue3DAxis*)
    axisZChanged             : ClassVar[Signal] = ... # axisZChanged(QValue3DAxis*)
    selectedSeriesChanged    : ClassVar[Signal] = ... # selectedSeriesChanged(QScatter3DSeries*)

    def __init__(self) -> None: ...

    def addAxis(self, axis: PySide6.QtGraphs.QValue3DAxis) -> None: ...
    def addSeries(self, series: PySide6.QtGraphs.QScatter3DSeries) -> None: ...
    def axes(self) -> List[PySide6.QtGraphs.QValue3DAxis]: ...
    def axisX(self) -> PySide6.QtGraphs.QValue3DAxis: ...
    def axisY(self) -> PySide6.QtGraphs.QValue3DAxis: ...
    def axisZ(self) -> PySide6.QtGraphs.QValue3DAxis: ...
    def releaseAxis(self, axis: PySide6.QtGraphs.QValue3DAxis) -> None: ...
    def removeSeries(self, series: PySide6.QtGraphs.QScatter3DSeries) -> None: ...
    def selectedSeries(self) -> PySide6.QtGraphs.QScatter3DSeries: ...
    def seriesList(self) -> List[PySide6.QtGraphs.QScatter3DSeries]: ...
    def setAxisX(self, axis: PySide6.QtGraphs.QValue3DAxis) -> None: ...
    def setAxisY(self, axis: PySide6.QtGraphs.QValue3DAxis) -> None: ...
    def setAxisZ(self, axis: PySide6.QtGraphs.QValue3DAxis) -> None: ...


class Q3DScene(PySide6.QtCore.QObject):

    devicePixelRatioChanged  : ClassVar[Signal] = ... # devicePixelRatioChanged(float)
    graphPositionQueryChanged: ClassVar[Signal] = ... # graphPositionQueryChanged(QPoint)
    needRender               : ClassVar[Signal] = ... # needRender()
    primarySubViewportChanged: ClassVar[Signal] = ... # primarySubViewportChanged(QRect)
    secondarySubViewportChanged: ClassVar[Signal] = ... # secondarySubViewportChanged(QRect)
    secondarySubviewOnTopChanged: ClassVar[Signal] = ... # secondarySubviewOnTopChanged(bool)
    selectionQueryPositionChanged: ClassVar[Signal] = ... # selectionQueryPositionChanged(QPoint)
    slicingActiveChanged     : ClassVar[Signal] = ... # slicingActiveChanged(bool)
    viewportChanged          : ClassVar[Signal] = ... # viewportChanged(QRect)

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def devicePixelRatio(self) -> float: ...
    def graphPositionQuery(self) -> PySide6.QtCore.QPoint: ...
    def invalidSelectionPoint(self) -> PySide6.QtCore.QPoint: ...
    def isPointInPrimarySubView(self, point: PySide6.QtCore.QPoint) -> bool: ...
    def isPointInSecondarySubView(self, point: PySide6.QtCore.QPoint) -> bool: ...
    def isSecondarySubviewOnTop(self) -> bool: ...
    def isSlicingActive(self) -> bool: ...
    def primarySubViewport(self) -> PySide6.QtCore.QRect: ...
    def secondarySubViewport(self) -> PySide6.QtCore.QRect: ...
    def selectionQueryPosition(self) -> PySide6.QtCore.QPoint: ...
    def setDevicePixelRatio(self, pixelRatio: float) -> None: ...
    def setGraphPositionQuery(self, point: PySide6.QtCore.QPoint) -> None: ...
    def setPrimarySubViewport(self, primarySubViewport: PySide6.QtCore.QRect) -> None: ...
    def setSecondarySubViewport(self, secondarySubViewport: PySide6.QtCore.QRect) -> None: ...
    def setSecondarySubviewOnTop(self, isSecondaryOnTop: bool) -> None: ...
    def setSelectionQueryPosition(self, point: PySide6.QtCore.QPoint) -> None: ...
    def setSlicingActive(self, isSlicing: bool) -> None: ...
    def viewport(self) -> PySide6.QtCore.QRect: ...


class Q3DSurface(PySide6.QtGraphs.QAbstract3DGraph):

    axisXChanged             : ClassVar[Signal] = ... # axisXChanged(QValue3DAxis*)
    axisYChanged             : ClassVar[Signal] = ... # axisYChanged(QValue3DAxis*)
    axisZChanged             : ClassVar[Signal] = ... # axisZChanged(QValue3DAxis*)
    flipHorizontalGridChanged: ClassVar[Signal] = ... # flipHorizontalGridChanged(bool)
    selectedSeriesChanged    : ClassVar[Signal] = ... # selectedSeriesChanged(QSurface3DSeries*)

    def __init__(self) -> None: ...

    def addAxis(self, axis: PySide6.QtGraphs.QValue3DAxis) -> None: ...
    def addSeries(self, series: PySide6.QtGraphs.QSurface3DSeries) -> None: ...
    def axes(self) -> List[PySide6.QtGraphs.QValue3DAxis]: ...
    def axisX(self) -> PySide6.QtGraphs.QValue3DAxis: ...
    def axisY(self) -> PySide6.QtGraphs.QValue3DAxis: ...
    def axisZ(self) -> PySide6.QtGraphs.QValue3DAxis: ...
    def flipHorizontalGrid(self) -> bool: ...
    def releaseAxis(self, axis: PySide6.QtGraphs.QValue3DAxis) -> None: ...
    def removeSeries(self, series: PySide6.QtGraphs.QSurface3DSeries) -> None: ...
    def selectedSeries(self) -> PySide6.QtGraphs.QSurface3DSeries: ...
    def seriesList(self) -> List[PySide6.QtGraphs.QSurface3DSeries]: ...
    def setAxisX(self, axis: PySide6.QtGraphs.QValue3DAxis) -> None: ...
    def setAxisY(self, axis: PySide6.QtGraphs.QValue3DAxis) -> None: ...
    def setAxisZ(self, axis: PySide6.QtGraphs.QValue3DAxis) -> None: ...
    def setFlipHorizontalGrid(self, flip: bool) -> None: ...


class Q3DTheme(PySide6.QtCore.QObject, PySide6.QtQml.QQmlParserStatus):

    ambientLightStrengthChanged: ClassVar[Signal] = ... # ambientLightStrengthChanged(float)
    backgroundColorChanged   : ClassVar[Signal] = ... # backgroundColorChanged(QColor)
    backgroundEnabledChanged : ClassVar[Signal] = ... # backgroundEnabledChanged(bool)
    baseColorsChanged        : ClassVar[Signal] = ... # baseColorsChanged(QList<QColor>)
    baseGradientsChanged     : ClassVar[Signal] = ... # baseGradientsChanged(QList<QLinearGradient>)
    colorStyleChanged        : ClassVar[Signal] = ... # colorStyleChanged(Q3DTheme::ColorStyle)
    fontChanged              : ClassVar[Signal] = ... # fontChanged(QFont)
    gridEnabledChanged       : ClassVar[Signal] = ... # gridEnabledChanged(bool)
    gridLineColorChanged     : ClassVar[Signal] = ... # gridLineColorChanged(QColor)
    labelBackgroundColorChanged: ClassVar[Signal] = ... # labelBackgroundColorChanged(QColor)
    labelBackgroundEnabledChanged: ClassVar[Signal] = ... # labelBackgroundEnabledChanged(bool)
    labelBorderEnabledChanged: ClassVar[Signal] = ... # labelBorderEnabledChanged(bool)
    labelTextColorChanged    : ClassVar[Signal] = ... # labelTextColorChanged(QColor)
    labelsEnabledChanged     : ClassVar[Signal] = ... # labelsEnabledChanged(bool)
    lightColorChanged        : ClassVar[Signal] = ... # lightColorChanged(QColor)
    lightStrengthChanged     : ClassVar[Signal] = ... # lightStrengthChanged(float)
    multiHighlightColorChanged: ClassVar[Signal] = ... # multiHighlightColorChanged(QColor)
    multiHighlightGradientChanged: ClassVar[Signal] = ... # multiHighlightGradientChanged(QLinearGradient)
    multiHighlightGradientChangedQML: ClassVar[Signal] = ... # multiHighlightGradientChangedQML(QJSValue)
    needRender               : ClassVar[Signal] = ... # needRender()
    shadowStrengthChanged    : ClassVar[Signal] = ... # shadowStrengthChanged(float)
    singleHighlightColorChanged: ClassVar[Signal] = ... # singleHighlightColorChanged(QColor)
    singleHighlightGradientChanged: ClassVar[Signal] = ... # singleHighlightGradientChanged(QLinearGradient)
    singleHighlightGradientQMLChanged: ClassVar[Signal] = ... # singleHighlightGradientQMLChanged(QJSValue)
    typeChanged              : ClassVar[Signal] = ... # typeChanged(Q3DTheme::Theme)
    windowColorChanged       : ClassVar[Signal] = ... # windowColorChanged(QColor)

    class ColorStyle(enum.Enum):

        Uniform                  : Q3DTheme.ColorStyle = ... # 0x0
        ObjectGradient           : Q3DTheme.ColorStyle = ... # 0x1
        RangeGradient            : Q3DTheme.ColorStyle = ... # 0x2

    class Theme(enum.Enum):

        Qt                       : Q3DTheme.Theme = ... # 0x0
        PrimaryColors            : Q3DTheme.Theme = ... # 0x1
        StoneMoss                : Q3DTheme.Theme = ... # 0x2
        ArmyBlue                 : Q3DTheme.Theme = ... # 0x3
        Retro                    : Q3DTheme.Theme = ... # 0x4
        Ebony                    : Q3DTheme.Theme = ... # 0x5
        Isabelle                 : Q3DTheme.Theme = ... # 0x6
        UserDefined              : Q3DTheme.Theme = ... # 0x7


    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, themeType: PySide6.QtGraphs.Q3DTheme.Theme, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def ambientLightStrength(self) -> float: ...
    def backgroundColor(self) -> PySide6.QtGui.QColor: ...
    def baseColors(self) -> List[PySide6.QtGui.QColor]: ...
    def baseGradients(self) -> List[PySide6.QtGui.QLinearGradient]: ...
    def classBegin(self) -> None: ...
    def colorStyle(self) -> PySide6.QtGraphs.Q3DTheme.ColorStyle: ...
    def componentComplete(self) -> None: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def gridLineColor(self) -> PySide6.QtGui.QColor: ...
    def handleBaseColorUpdate(self) -> None: ...
    def handleBaseGradientUpdate(self) -> None: ...
    def handleMultiHLGradientUpdate(self) -> None: ...
    def handleSingleHLGradientUpdate(self) -> None: ...
    def handleTypeChange(self, themeType: PySide6.QtGraphs.Q3DTheme.Theme) -> None: ...
    def isBackgroundEnabled(self) -> bool: ...
    def isGridEnabled(self) -> bool: ...
    def isLabelBackgroundEnabled(self) -> bool: ...
    def isLabelBorderEnabled(self) -> bool: ...
    def isLabelsEnabled(self) -> bool: ...
    def labelBackgroundColor(self) -> PySide6.QtGui.QColor: ...
    def labelTextColor(self) -> PySide6.QtGui.QColor: ...
    def lightColor(self) -> PySide6.QtGui.QColor: ...
    def lightStrength(self) -> float: ...
    def multiHighlightColor(self) -> PySide6.QtGui.QColor: ...
    def multiHighlightGradient(self) -> PySide6.QtGui.QLinearGradient: ...
    def setAmbientLightStrength(self, strength: float) -> None: ...
    def setBackgroundColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setBackgroundEnabled(self, enabled: bool) -> None: ...
    def setBaseColors(self, colors: Sequence[PySide6.QtGui.QColor]) -> None: ...
    def setBaseGradients(self, gradients: Sequence[PySide6.QtGui.QLinearGradient]) -> None: ...
    def setColorStyle(self, style: PySide6.QtGraphs.Q3DTheme.ColorStyle) -> None: ...
    def setFont(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def setGridEnabled(self, enabled: bool) -> None: ...
    def setGridLineColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setLabelBackgroundColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setLabelBackgroundEnabled(self, enabled: bool) -> None: ...
    def setLabelBorderEnabled(self, enabled: bool) -> None: ...
    def setLabelTextColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setLabelsEnabled(self, enabled: bool) -> None: ...
    def setLightColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setLightStrength(self, strength: float) -> None: ...
    def setMultiHighlightColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setMultiHighlightGradient(self, gradient: PySide6.QtGui.QLinearGradient) -> None: ...
    def setShadowStrength(self, strength: float) -> None: ...
    def setSingleHighlightColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setSingleHighlightGradient(self, gradient: PySide6.QtGui.QLinearGradient) -> None: ...
    def setType(self, themeType: PySide6.QtGraphs.Q3DTheme.Theme) -> None: ...
    def setWindowColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def shadowStrength(self) -> float: ...
    def singleHighlightColor(self) -> PySide6.QtGui.QColor: ...
    def singleHighlightGradient(self) -> PySide6.QtGui.QLinearGradient: ...
    def type(self) -> PySide6.QtGraphs.Q3DTheme.Theme: ...
    def windowColor(self) -> PySide6.QtGui.QColor: ...


class QAbstract3DAxis(PySide6.QtCore.QObject):

    autoAdjustRangeChanged   : ClassVar[Signal] = ... # autoAdjustRangeChanged(bool)
    labelAutoRotationChanged : ClassVar[Signal] = ... # labelAutoRotationChanged(float)
    labelsChanged            : ClassVar[Signal] = ... # labelsChanged()
    maxChanged               : ClassVar[Signal] = ... # maxChanged(float)
    minChanged               : ClassVar[Signal] = ... # minChanged(float)
    orientationChanged       : ClassVar[Signal] = ... # orientationChanged(QAbstract3DAxis::AxisOrientation)
    rangeChanged             : ClassVar[Signal] = ... # rangeChanged(float,float)
    titleChanged             : ClassVar[Signal] = ... # titleChanged(QString)
    titleFixedChanged        : ClassVar[Signal] = ... # titleFixedChanged(bool)
    titleVisibilityChanged   : ClassVar[Signal] = ... # titleVisibilityChanged(bool)

    class AxisOrientation(enum.Enum):

        None_                    : QAbstract3DAxis.AxisOrientation = ... # 0x0
        X                        : QAbstract3DAxis.AxisOrientation = ... # 0x1
        Y                        : QAbstract3DAxis.AxisOrientation = ... # 0x2
        Z                        : QAbstract3DAxis.AxisOrientation = ... # 0x3

    class AxisType(enum.Enum):

        None_                    : QAbstract3DAxis.AxisType = ... # 0x0
        Category                 : QAbstract3DAxis.AxisType = ... # 0x1
        Value                    : QAbstract3DAxis.AxisType = ... # 0x2


    def isAutoAdjustRange(self) -> bool: ...
    def isTitleFixed(self) -> bool: ...
    def isTitleVisible(self) -> bool: ...
    def labelAutoRotation(self) -> float: ...
    def labels(self) -> List[str]: ...
    def max(self) -> float: ...
    def min(self) -> float: ...
    def orientation(self) -> PySide6.QtGraphs.QAbstract3DAxis.AxisOrientation: ...
    def setAutoAdjustRange(self, autoAdjust: bool) -> None: ...
    def setLabelAutoRotation(self, angle: float) -> None: ...
    def setLabels(self, labels: Sequence[str]) -> None: ...
    def setMax(self, max: float) -> None: ...
    def setMin(self, min: float) -> None: ...
    def setRange(self, min: float, max: float) -> None: ...
    def setTitle(self, title: str) -> None: ...
    def setTitleFixed(self, fixed: bool) -> None: ...
    def setTitleVisible(self, visible: bool) -> None: ...
    def title(self) -> str: ...
    def type(self) -> PySide6.QtGraphs.QAbstract3DAxis.AxisType: ...


class QAbstract3DGraph(PySide6.QtQuickWidgets.QQuickWidget):

    activeInputHandlerChanged: ClassVar[Signal] = ... # activeInputHandlerChanged(QAbstract3DInputHandler*)
    activeThemeChanged       : ClassVar[Signal] = ... # activeThemeChanged(Q3DTheme*)
    aspectRatioChanged       : ClassVar[Signal] = ... # aspectRatioChanged(double)
    cameraPresetChanged      : ClassVar[Signal] = ... # cameraPresetChanged(QAbstract3DGraph::CameraPreset)
    cameraTargetPositionChanged: ClassVar[Signal] = ... # cameraTargetPositionChanged(QVector3D)
    cameraXRotationChanged   : ClassVar[Signal] = ... # cameraXRotationChanged(float)
    cameraYRotationChanged   : ClassVar[Signal] = ... # cameraYRotationChanged(float)
    cameraZoomLevelChanged   : ClassVar[Signal] = ... # cameraZoomLevelChanged(float)
    currentFpsChanged        : ClassVar[Signal] = ... # currentFpsChanged(int)
    horizontalAspectRatioChanged: ClassVar[Signal] = ... # horizontalAspectRatioChanged(double)
    localeChanged            : ClassVar[Signal] = ... # localeChanged(QLocale)
    marginChanged            : ClassVar[Signal] = ... # marginChanged(double)
    maxCameraXRotationChanged: ClassVar[Signal] = ... # maxCameraXRotationChanged(float)
    maxCameraYRotationChanged: ClassVar[Signal] = ... # maxCameraYRotationChanged(float)
    maxCameraZoomLevelChanged: ClassVar[Signal] = ... # maxCameraZoomLevelChanged(float)
    measureFpsChanged        : ClassVar[Signal] = ... # measureFpsChanged(bool)
    minCameraXRotationChanged: ClassVar[Signal] = ... # minCameraXRotationChanged(float)
    minCameraYRotationChanged: ClassVar[Signal] = ... # minCameraYRotationChanged(float)
    minCameraZoomLevelChanged: ClassVar[Signal] = ... # minCameraZoomLevelChanged(float)
    msaaSamplesChanged       : ClassVar[Signal] = ... # msaaSamplesChanged(int)
    optimizationHintChanged  : ClassVar[Signal] = ... # optimizationHintChanged(QAbstract3DGraph::OptimizationHint)
    orthoProjectionChanged   : ClassVar[Signal] = ... # orthoProjectionChanged(bool)
    polarChanged             : ClassVar[Signal] = ... # polarChanged(bool)
    queriedGraphPositionChanged: ClassVar[Signal] = ... # queriedGraphPositionChanged(QVector3D)
    radialLabelOffsetChanged : ClassVar[Signal] = ... # radialLabelOffsetChanged(float)
    selectedElementChanged   : ClassVar[Signal] = ... # selectedElementChanged(QAbstract3DGraph::ElementType)
    selectionModeChanged     : ClassVar[Signal] = ... # selectionModeChanged(QAbstract3DGraph::SelectionFlags)
    shadowQualityChanged     : ClassVar[Signal] = ... # shadowQualityChanged(QAbstract3DGraph::ShadowQuality)
    wrapCameraXRotationChanged: ClassVar[Signal] = ... # wrapCameraXRotationChanged(bool)
    wrapCameraYRotationChanged: ClassVar[Signal] = ... # wrapCameraYRotationChanged(bool)

    class CameraPreset(enum.Enum):

        NoPreset                 : QAbstract3DGraph.CameraPreset = ... # 0x0
        FrontLow                 : QAbstract3DGraph.CameraPreset = ... # 0x1
        Front                    : QAbstract3DGraph.CameraPreset = ... # 0x2
        FrontHigh                : QAbstract3DGraph.CameraPreset = ... # 0x3
        LeftLow                  : QAbstract3DGraph.CameraPreset = ... # 0x4
        Left                     : QAbstract3DGraph.CameraPreset = ... # 0x5
        LeftHigh                 : QAbstract3DGraph.CameraPreset = ... # 0x6
        RightLow                 : QAbstract3DGraph.CameraPreset = ... # 0x7
        Right                    : QAbstract3DGraph.CameraPreset = ... # 0x8
        RightHigh                : QAbstract3DGraph.CameraPreset = ... # 0x9
        BehindLow                : QAbstract3DGraph.CameraPreset = ... # 0xa
        Behind                   : QAbstract3DGraph.CameraPreset = ... # 0xb
        BehindHigh               : QAbstract3DGraph.CameraPreset = ... # 0xc
        IsometricLeft            : QAbstract3DGraph.CameraPreset = ... # 0xd
        IsometricLeftHigh        : QAbstract3DGraph.CameraPreset = ... # 0xe
        IsometricRight           : QAbstract3DGraph.CameraPreset = ... # 0xf
        IsometricRightHigh       : QAbstract3DGraph.CameraPreset = ... # 0x10
        DirectlyAbove            : QAbstract3DGraph.CameraPreset = ... # 0x11
        DirectlyAboveCW45        : QAbstract3DGraph.CameraPreset = ... # 0x12
        DirectlyAboveCCW45       : QAbstract3DGraph.CameraPreset = ... # 0x13
        FrontBelow               : QAbstract3DGraph.CameraPreset = ... # 0x14
        LeftBelow                : QAbstract3DGraph.CameraPreset = ... # 0x15
        RightBelow               : QAbstract3DGraph.CameraPreset = ... # 0x16
        BehindBelow              : QAbstract3DGraph.CameraPreset = ... # 0x17
        DirectlyBelow            : QAbstract3DGraph.CameraPreset = ... # 0x18

    class ElementType(enum.Enum):

        None_                    : QAbstract3DGraph.ElementType = ... # 0x0
        Series                   : QAbstract3DGraph.ElementType = ... # 0x1
        AxisXLabel               : QAbstract3DGraph.ElementType = ... # 0x2
        AxisYLabel               : QAbstract3DGraph.ElementType = ... # 0x3
        AxisZLabel               : QAbstract3DGraph.ElementType = ... # 0x4
        CustomItem               : QAbstract3DGraph.ElementType = ... # 0x5

    class OptimizationHint(enum.Flag):

        Default                  : QAbstract3DGraph.OptimizationHint = ... # 0x0
        Legacy                   : QAbstract3DGraph.OptimizationHint = ... # 0x1

    class RenderingMode(enum.Enum):

        DirectToBackground       : QAbstract3DGraph.RenderingMode = ... # 0x0
        Indirect                 : QAbstract3DGraph.RenderingMode = ... # 0x1

    class SelectionFlag(enum.Flag):

        SelectionNone            : QAbstract3DGraph.SelectionFlag = ... # 0x0
        SelectionItem            : QAbstract3DGraph.SelectionFlag = ... # 0x1
        SelectionRow             : QAbstract3DGraph.SelectionFlag = ... # 0x2
        SelectionItemAndRow      : QAbstract3DGraph.SelectionFlag = ... # 0x3
        SelectionColumn          : QAbstract3DGraph.SelectionFlag = ... # 0x4
        SelectionItemAndColumn   : QAbstract3DGraph.SelectionFlag = ... # 0x5
        SelectionRowAndColumn    : QAbstract3DGraph.SelectionFlag = ... # 0x6
        SelectionItemRowAndColumn: QAbstract3DGraph.SelectionFlag = ... # 0x7
        SelectionSlice           : QAbstract3DGraph.SelectionFlag = ... # 0x8
        SelectionMultiSeries     : QAbstract3DGraph.SelectionFlag = ... # 0x10

    class ShadowQuality(enum.Enum):

        None_                    : QAbstract3DGraph.ShadowQuality = ... # 0x0
        Low                      : QAbstract3DGraph.ShadowQuality = ... # 0x1
        Medium                   : QAbstract3DGraph.ShadowQuality = ... # 0x2
        High                     : QAbstract3DGraph.ShadowQuality = ... # 0x3
        SoftLow                  : QAbstract3DGraph.ShadowQuality = ... # 0x4
        SoftMedium               : QAbstract3DGraph.ShadowQuality = ... # 0x5
        SoftHigh                 : QAbstract3DGraph.ShadowQuality = ... # 0x6


    def __init__(self, graphType: str) -> None: ...

    def activeInputHandler(self) -> PySide6.QtGraphs.QAbstract3DInputHandler: ...
    def activeTheme(self) -> PySide6.QtGraphs.Q3DTheme: ...
    def addCustomItem(self, item: PySide6.QtGraphs.QCustom3DItem) -> int: ...
    def addInputHandler(self, inputHandler: PySide6.QtGraphs.QAbstract3DInputHandler) -> None: ...
    def addTheme(self, theme: PySide6.QtGraphs.Q3DTheme) -> None: ...
    def aspectRatio(self) -> float: ...
    def cameraPreset(self) -> PySide6.QtGraphs.QAbstract3DGraph.CameraPreset: ...
    def cameraTargetPosition(self) -> PySide6.QtGui.QVector3D: ...
    def cameraXRotation(self) -> float: ...
    def cameraYRotation(self) -> float: ...
    def cameraZoomLevel(self) -> float: ...
    def clearSelection(self) -> None: ...
    def currentFps(self) -> int: ...
    def customItems(self) -> List[PySide6.QtGraphs.QCustom3DItem]: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def hasSeries(self, series: PySide6.QtGraphs.QAbstract3DSeries) -> bool: ...
    def horizontalAspectRatio(self) -> float: ...
    def inputHandlers(self) -> List[PySide6.QtGraphs.QAbstract3DInputHandler]: ...
    def isOrthoProjection(self) -> bool: ...
    def isPolar(self) -> bool: ...
    def locale(self) -> PySide6.QtCore.QLocale: ...
    def margin(self) -> float: ...
    def maxCameraXRotation(self) -> float: ...
    def maxCameraYRotation(self) -> float: ...
    def maxCameraZoomLevel(self) -> float: ...
    def measureFps(self) -> bool: ...
    def minCameraXRotation(self) -> float: ...
    def minCameraYRotation(self) -> float: ...
    def minCameraZoomLevel(self) -> float: ...
    def mouseDoubleClickEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def msaaSamples(self) -> int: ...
    def optimizationHint(self) -> PySide6.QtGraphs.QAbstract3DGraph.OptimizationHint: ...
    def queriedGraphPosition(self) -> PySide6.QtGui.QVector3D: ...
    def radialLabelOffset(self) -> float: ...
    def releaseCustomItem(self, item: PySide6.QtGraphs.QCustom3DItem) -> None: ...
    def releaseInputHandler(self, inputHandler: PySide6.QtGraphs.QAbstract3DInputHandler) -> None: ...
    def releaseTheme(self, theme: PySide6.QtGraphs.Q3DTheme) -> None: ...
    def removeCustomItem(self, item: PySide6.QtGraphs.QCustom3DItem) -> None: ...
    def removeCustomItemAt(self, position: PySide6.QtGui.QVector3D) -> None: ...
    def removeCustomItems(self) -> None: ...
    def renderToImage(self, imageSize: PySide6.QtCore.QSize = ...) -> Tuple[PySide6.QtQuick.QQuickItemGrabResult]: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent) -> None: ...
    def scene(self) -> PySide6.QtGraphs.Q3DScene: ...
    def selectedAxis(self) -> PySide6.QtGraphs.QAbstract3DAxis: ...
    def selectedCustomItem(self) -> PySide6.QtGraphs.QCustom3DItem: ...
    def selectedCustomItemIndex(self) -> int: ...
    def selectedElement(self) -> PySide6.QtGraphs.QAbstract3DGraph.ElementType: ...
    def selectedLabelIndex(self) -> int: ...
    def selectionMode(self) -> PySide6.QtGraphs.QAbstract3DGraph.SelectionFlag: ...
    def setActiveInputHandler(self, inputHandler: PySide6.QtGraphs.QAbstract3DInputHandler) -> None: ...
    def setActiveTheme(self, activeTheme: PySide6.QtGraphs.Q3DTheme) -> None: ...
    def setAspectRatio(self, ratio: float) -> None: ...
    def setCameraPosition(self, horizontal: float, vertical: float, zoom: float = ...) -> None: ...
    def setCameraPreset(self, preset: PySide6.QtGraphs.QAbstract3DGraph.CameraPreset) -> None: ...
    def setCameraTargetPosition(self, target: PySide6.QtGui.QVector3D) -> None: ...
    def setCameraXRotation(self, rotation: float) -> None: ...
    def setCameraYRotation(self, rotation: float) -> None: ...
    def setCameraZoomLevel(self, level: float) -> None: ...
    def setHorizontalAspectRatio(self, ratio: float) -> None: ...
    def setLocale(self, locale: Union[PySide6.QtCore.QLocale, PySide6.QtCore.QLocale.Language]) -> None: ...
    def setMargin(self, margin: float) -> None: ...
    def setMaxCameraXRotation(self, rotation: float) -> None: ...
    def setMaxCameraYRotation(self, rotation: float) -> None: ...
    def setMaxCameraZoomLevel(self, level: float) -> None: ...
    def setMeasureFps(self, enable: bool) -> None: ...
    def setMinCameraXRotation(self, rotation: float) -> None: ...
    def setMinCameraYRotation(self, rotation: float) -> None: ...
    def setMinCameraZoomLevel(self, level: float) -> None: ...
    def setMsaaSamples(self, samples: int) -> None: ...
    def setOptimizationHint(self, hint: PySide6.QtGraphs.QAbstract3DGraph.OptimizationHint) -> None: ...
    def setOrthoProjection(self, enable: bool) -> None: ...
    def setPolar(self, enable: bool) -> None: ...
    def setRadialLabelOffset(self, offset: float) -> None: ...
    def setSelectionMode(self, selectionMode: PySide6.QtGraphs.QAbstract3DGraph.SelectionFlag) -> None: ...
    def setShadowQuality(self, shadowQuality: PySide6.QtGraphs.QAbstract3DGraph.ShadowQuality) -> None: ...
    def setWrapCameraXRotation(self, wrap: bool) -> None: ...
    def setWrapCameraYRotation(self, wrap: bool) -> None: ...
    def shadowQuality(self) -> PySide6.QtGraphs.QAbstract3DGraph.ShadowQuality: ...
    def themes(self) -> List[PySide6.QtGraphs.Q3DTheme]: ...
    def wheelEvent(self, event: PySide6.QtGui.QWheelEvent) -> None: ...
    def wrapCameraXRotation(self) -> bool: ...
    def wrapCameraYRotation(self) -> bool: ...


class QAbstract3DInputHandler(PySide6.QtCore.QObject):

    inputViewChanged         : ClassVar[Signal] = ... # inputViewChanged(QAbstract3DInputHandler::InputView)
    positionChanged          : ClassVar[Signal] = ... # positionChanged(QPoint)
    sceneChanged             : ClassVar[Signal] = ... # sceneChanged(Q3DScene*)

    class InputView(enum.Enum):

        None_                    : QAbstract3DInputHandler.InputView = ... # 0x0
        OnPrimary                : QAbstract3DInputHandler.InputView = ... # 0x1
        OnSecondary              : QAbstract3DInputHandler.InputView = ... # 0x2


    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def cameraXRotation(self) -> float: ...
    def cameraYRotation(self) -> float: ...
    def cameraZoomLevel(self) -> float: ...
    def handleSelection(self, position: PySide6.QtCore.QPoint) -> None: ...
    def inputPosition(self) -> PySide6.QtCore.QPoint: ...
    def inputView(self) -> PySide6.QtGraphs.QAbstract3DInputHandler.InputView: ...
    def maxCameraXRotation(self) -> float: ...
    def maxCameraYRotation(self) -> float: ...
    def minCameraXRotation(self) -> float: ...
    def minCameraYRotation(self) -> float: ...
    def mouseDoubleClickEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: PySide6.QtGui.QMouseEvent, mousePos: PySide6.QtCore.QPoint) -> None: ...
    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent, mousePos: PySide6.QtCore.QPoint) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtGui.QMouseEvent, mousePos: PySide6.QtCore.QPoint) -> None: ...
    def prevDistance(self) -> int: ...
    def previousInputPos(self) -> PySide6.QtCore.QPoint: ...
    def scene(self) -> PySide6.QtGraphs.Q3DScene: ...
    def setCameraXRotation(self, rotation: float) -> None: ...
    def setCameraYRotation(self, rotation: float) -> None: ...
    def setCameraZoomLevel(self, level: float) -> None: ...
    def setInputPosition(self, position: PySide6.QtCore.QPoint, forceSelection: bool = ...) -> None: ...
    def setInputView(self, inputView: PySide6.QtGraphs.QAbstract3DInputHandler.InputView) -> None: ...
    def setMaxCameraXRotation(self, rotation: float) -> None: ...
    def setMaxCameraYRotation(self, rotation: float) -> None: ...
    def setMinCameraXRotation(self, rotation: float) -> None: ...
    def setMinCameraYRotation(self, rotation: float) -> None: ...
    def setPrevDistance(self, distance: int) -> None: ...
    def setPreviousInputPos(self, position: PySide6.QtCore.QPoint) -> None: ...
    def setScene(self, scene: PySide6.QtGraphs.Q3DScene) -> None: ...
    def touchEvent(self, event: PySide6.QtGui.QTouchEvent) -> None: ...
    def wheelEvent(self, event: PySide6.QtGui.QWheelEvent) -> None: ...


class QAbstract3DSeries(PySide6.QtCore.QObject):

    baseColorChanged         : ClassVar[Signal] = ... # baseColorChanged(QColor)
    baseGradientChanged      : ClassVar[Signal] = ... # baseGradientChanged(QLinearGradient)
    colorStyleChanged        : ClassVar[Signal] = ... # colorStyleChanged(Q3DTheme::ColorStyle)
    itemLabelChanged         : ClassVar[Signal] = ... # itemLabelChanged(QString)
    itemLabelFormatChanged   : ClassVar[Signal] = ... # itemLabelFormatChanged(QString)
    itemLabelVisibilityChanged: ClassVar[Signal] = ... # itemLabelVisibilityChanged(bool)
    meshChanged              : ClassVar[Signal] = ... # meshChanged(QAbstract3DSeries::Mesh)
    meshRotationChanged      : ClassVar[Signal] = ... # meshRotationChanged(QQuaternion)
    meshSmoothChanged        : ClassVar[Signal] = ... # meshSmoothChanged(bool)
    multiHighlightColorChanged: ClassVar[Signal] = ... # multiHighlightColorChanged(QColor)
    multiHighlightGradientChanged: ClassVar[Signal] = ... # multiHighlightGradientChanged(QLinearGradient)
    nameChanged              : ClassVar[Signal] = ... # nameChanged(QString)
    singleHighlightColorChanged: ClassVar[Signal] = ... # singleHighlightColorChanged(QColor)
    singleHighlightGradientChanged: ClassVar[Signal] = ... # singleHighlightGradientChanged(QLinearGradient)
    userDefinedMeshChanged   : ClassVar[Signal] = ... # userDefinedMeshChanged(QString)
    visibilityChanged        : ClassVar[Signal] = ... # visibilityChanged(bool)

    class Mesh(enum.Enum):

        UserDefined              : QAbstract3DSeries.Mesh = ... # 0x0
        Bar                      : QAbstract3DSeries.Mesh = ... # 0x1
        Cube                     : QAbstract3DSeries.Mesh = ... # 0x2
        Pyramid                  : QAbstract3DSeries.Mesh = ... # 0x3
        Cone                     : QAbstract3DSeries.Mesh = ... # 0x4
        Cylinder                 : QAbstract3DSeries.Mesh = ... # 0x5
        BevelBar                 : QAbstract3DSeries.Mesh = ... # 0x6
        BevelCube                : QAbstract3DSeries.Mesh = ... # 0x7
        Sphere                   : QAbstract3DSeries.Mesh = ... # 0x8
        Minimal                  : QAbstract3DSeries.Mesh = ... # 0x9
        Arrow                    : QAbstract3DSeries.Mesh = ... # 0xa
        Point                    : QAbstract3DSeries.Mesh = ... # 0xb

    class SeriesType(enum.Enum):

        None_                    : QAbstract3DSeries.SeriesType = ... # 0x0
        Bar                      : QAbstract3DSeries.SeriesType = ... # 0x1
        Scatter                  : QAbstract3DSeries.SeriesType = ... # 0x2
        Surface                  : QAbstract3DSeries.SeriesType = ... # 0x3


    def baseColor(self) -> PySide6.QtGui.QColor: ...
    def baseGradient(self) -> PySide6.QtGui.QLinearGradient: ...
    def colorStyle(self) -> PySide6.QtGraphs.Q3DTheme.ColorStyle: ...
    def isItemLabelVisible(self) -> bool: ...
    def isMeshSmooth(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def itemLabel(self) -> str: ...
    def itemLabelFormat(self) -> str: ...
    def mesh(self) -> PySide6.QtGraphs.QAbstract3DSeries.Mesh: ...
    def meshRotation(self) -> PySide6.QtGui.QQuaternion: ...
    def multiHighlightColor(self) -> PySide6.QtGui.QColor: ...
    def multiHighlightGradient(self) -> PySide6.QtGui.QLinearGradient: ...
    def name(self) -> str: ...
    def setBaseColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setBaseGradient(self, gradient: PySide6.QtGui.QLinearGradient) -> None: ...
    def setColorStyle(self, style: PySide6.QtGraphs.Q3DTheme.ColorStyle) -> None: ...
    def setItemLabelFormat(self, format: str) -> None: ...
    def setItemLabelVisible(self, visible: bool) -> None: ...
    def setMesh(self, mesh: PySide6.QtGraphs.QAbstract3DSeries.Mesh) -> None: ...
    def setMeshAxisAndAngle(self, axis: PySide6.QtGui.QVector3D, angle: float) -> None: ...
    def setMeshRotation(self, rotation: PySide6.QtGui.QQuaternion) -> None: ...
    def setMeshSmooth(self, enable: bool) -> None: ...
    def setMultiHighlightColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setMultiHighlightGradient(self, gradient: PySide6.QtGui.QLinearGradient) -> None: ...
    def setName(self, name: str) -> None: ...
    def setSingleHighlightColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setSingleHighlightGradient(self, gradient: PySide6.QtGui.QLinearGradient) -> None: ...
    def setUserDefinedMesh(self, fileName: str) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def singleHighlightColor(self) -> PySide6.QtGui.QColor: ...
    def singleHighlightGradient(self) -> PySide6.QtGui.QLinearGradient: ...
    def type(self) -> PySide6.QtGraphs.QAbstract3DSeries.SeriesType: ...
    def userDefinedMesh(self) -> str: ...


class QAbstractAxis(PySide6.QtCore.QObject):

    gridVisibleChanged       : ClassVar[Signal] = ... # gridVisibleChanged(bool)
    labelsAngleChanged       : ClassVar[Signal] = ... # labelsAngleChanged(double)
    labelsVisibleChanged     : ClassVar[Signal] = ... # labelsVisibleChanged(bool)
    lineVisibleChanged       : ClassVar[Signal] = ... # lineVisibleChanged(bool)
    minorGridVisibleChanged  : ClassVar[Signal] = ... # minorGridVisibleChanged(bool)
    titleColorChanged        : ClassVar[Signal] = ... # titleColorChanged(QColor)
    titleFontChanged         : ClassVar[Signal] = ... # titleFontChanged(QFont)
    titleTextChanged         : ClassVar[Signal] = ... # titleTextChanged(QString)
    titleVisibleChanged      : ClassVar[Signal] = ... # titleVisibleChanged(bool)
    update                   : ClassVar[Signal] = ... # update()
    visibleChanged           : ClassVar[Signal] = ... # visibleChanged(bool)

    class AxisType(enum.Enum):

        AxisTypeNoAxis           : QAbstractAxis.AxisType = ... # 0x0
        AxisTypeValue            : QAbstractAxis.AxisType = ... # 0x1
        AxisTypeBarCategory      : QAbstractAxis.AxisType = ... # 0x2


    def alignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def hide(self) -> None: ...
    def isGridLineVisible(self) -> bool: ...
    def isLineVisible(self) -> bool: ...
    def isMinorGridLineVisible(self) -> bool: ...
    def isTitleVisible(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def labelsAngle(self) -> float: ...
    def labelsVisible(self) -> bool: ...
    def orientation(self) -> PySide6.QtCore.Qt.Orientation: ...
    def setGridLineVisible(self, visible: bool = ...) -> None: ...
    def setLabelsAngle(self, angle: float) -> None: ...
    def setLabelsVisible(self, visible: bool = ...) -> None: ...
    def setLineVisible(self, visible: bool = ...) -> None: ...
    def setMax(self, max: Any) -> None: ...
    def setMin(self, min: Any) -> None: ...
    def setMinorGridLineVisible(self, visible: bool = ...) -> None: ...
    def setOrientation(self, orientation: PySide6.QtCore.Qt.Orientation) -> None: ...
    def setRange(self, min: Any, max: Any) -> None: ...
    def setTitleColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setTitleFont(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def setTitleText(self, title: str) -> None: ...
    def setTitleVisible(self, visible: bool = ...) -> None: ...
    def setVisible(self, visible: bool = ...) -> None: ...
    def show(self) -> None: ...
    def titleColor(self) -> PySide6.QtGui.QColor: ...
    def titleFont(self) -> PySide6.QtGui.QFont: ...
    def titleText(self) -> str: ...
    def type(self) -> PySide6.QtGraphs.QAbstractAxis.AxisType: ...


class QAbstractBarSeries(PySide6.QtGraphs.QAbstractSeries):

    barWidthChanged          : ClassVar[Signal] = ... # barWidthChanged()
    barsetsAdded             : ClassVar[Signal] = ... # barsetsAdded(QList<QBarSet*>)
    barsetsRemoved           : ClassVar[Signal] = ... # barsetsRemoved(QList<QBarSet*>)
    clicked                  : ClassVar[Signal] = ... # clicked(int,QBarSet*)
    countChanged             : ClassVar[Signal] = ... # countChanged()
    doubleClicked            : ClassVar[Signal] = ... # doubleClicked(int,QBarSet*)
    hovered                  : ClassVar[Signal] = ... # hovered(bool,int,QBarSet*)
    labelsAngleChanged       : ClassVar[Signal] = ... # labelsAngleChanged(double)
    labelsFormatChanged      : ClassVar[Signal] = ... # labelsFormatChanged(QString)
    labelsPositionChanged    : ClassVar[Signal] = ... # labelsPositionChanged(QAbstractBarSeries::LabelsPosition)
    labelsPrecisionChanged   : ClassVar[Signal] = ... # labelsPrecisionChanged(int)
    labelsVisibleChanged     : ClassVar[Signal] = ... # labelsVisibleChanged()
    pressed                  : ClassVar[Signal] = ... # pressed(int,QBarSet*)
    released                 : ClassVar[Signal] = ... # released(int,QBarSet*)

    class LabelsPosition(enum.Enum):

        LabelsCenter             : QAbstractBarSeries.LabelsPosition = ... # 0x0
        LabelsInsideEnd          : QAbstractBarSeries.LabelsPosition = ... # 0x1
        LabelsInsideBase         : QAbstractBarSeries.LabelsPosition = ... # 0x2
        LabelsOutsideEnd         : QAbstractBarSeries.LabelsPosition = ... # 0x3


    @overload
    def append(self, set: PySide6.QtGraphs.QBarSet) -> bool: ...
    @overload
    def append(self, sets: Sequence[PySide6.QtGraphs.QBarSet]) -> bool: ...
    def barSets(self) -> List[PySide6.QtGraphs.QBarSet]: ...
    def barWidth(self) -> float: ...
    def clear(self) -> None: ...
    def componentComplete(self) -> None: ...
    def count(self) -> int: ...
    def deselectAll(self) -> None: ...
    def insert(self, index: int, set: PySide6.QtGraphs.QBarSet) -> bool: ...
    def isLabelsVisible(self) -> bool: ...
    def labelsAngle(self) -> float: ...
    def labelsFormat(self) -> str: ...
    def labelsPosition(self) -> PySide6.QtGraphs.QAbstractBarSeries.LabelsPosition: ...
    def labelsPrecision(self) -> int: ...
    def remove(self, set: PySide6.QtGraphs.QBarSet) -> bool: ...
    def selectAll(self) -> None: ...
    def setBarWidth(self, width: float) -> None: ...
    def setLabelsAngle(self, angle: float) -> None: ...
    def setLabelsFormat(self, format: str) -> None: ...
    def setLabelsPosition(self, position: PySide6.QtGraphs.QAbstractBarSeries.LabelsPosition) -> None: ...
    def setLabelsPrecision(self, precision: int) -> None: ...
    def setLabelsVisible(self, visible: bool = ...) -> None: ...
    def take(self, set: PySide6.QtGraphs.QBarSet) -> bool: ...


class QAbstractDataProxy(PySide6.QtCore.QObject):

    class DataType(enum.Enum):

        None_                    : QAbstractDataProxy.DataType = ... # 0x0
        Bar                      : QAbstractDataProxy.DataType = ... # 0x1
        Scatter                  : QAbstractDataProxy.DataType = ... # 0x2
        Surface                  : QAbstractDataProxy.DataType = ... # 0x3


    def type(self) -> PySide6.QtGraphs.QAbstractDataProxy.DataType: ...


class QAbstractSeries(PySide6.QtCore.QObject, PySide6.QtQml.QQmlParserStatus):

    hover                    : ClassVar[Signal] = ... # hover(QString,QPointF,QPointF)
    hoverEnter               : ClassVar[Signal] = ... # hoverEnter(QString,QPointF,QPointF)
    hoverExit                : ClassVar[Signal] = ... # hoverExit(QString,QPointF)
    hoverableChanged         : ClassVar[Signal] = ... # hoverableChanged()
    nameChanged              : ClassVar[Signal] = ... # nameChanged()
    opacityChanged           : ClassVar[Signal] = ... # opacityChanged()
    selectableChanged        : ClassVar[Signal] = ... # selectableChanged()
    themeChanged             : ClassVar[Signal] = ... # themeChanged()
    update                   : ClassVar[Signal] = ... # update()
    valuesMultiplierChanged  : ClassVar[Signal] = ... # valuesMultiplierChanged()
    visibleChanged           : ClassVar[Signal] = ... # visibleChanged()

    class SeriesType(enum.Enum):

        SeriesTypeLine           : QAbstractSeries.SeriesType = ... # 0x0
        SeriesTypeBar            : QAbstractSeries.SeriesType = ... # 0x1
        SeriesTypeScatter        : QAbstractSeries.SeriesType = ... # 0x2


    def attachAxis(self, axis: PySide6.QtGraphs.QAbstractAxis) -> bool: ...
    def attachedAxes(self) -> List[PySide6.QtGraphs.QAbstractAxis]: ...
    def classBegin(self) -> None: ...
    def componentComplete(self) -> None: ...
    def detachAxis(self, axis: PySide6.QtGraphs.QAbstractAxis) -> bool: ...
    def hide(self) -> None: ...
    def hoverable(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def name(self) -> str: ...
    def opacity(self) -> float: ...
    def selectable(self) -> bool: ...
    def setHoverable(self, newHoverable: bool) -> None: ...
    def setName(self, name: str) -> None: ...
    def setOpacity(self, opacity: float) -> None: ...
    def setSelectable(self, selectable: bool) -> None: ...
    def setTheme(self, newTheme: PySide6.QtGraphs.QSeriesTheme) -> None: ...
    def setValuesMultiplier(self, valuesMultiplier: float) -> None: ...
    def setVisible(self, visible: bool = ...) -> None: ...
    def show(self) -> None: ...
    def theme(self) -> PySide6.QtGraphs.QSeriesTheme: ...
    def type(self) -> PySide6.QtGraphs.QAbstractSeries.SeriesType: ...
    def valuesMultiplier(self) -> float: ...


class QBar3DSeries(PySide6.QtGraphs.QAbstract3DSeries):

    dataProxyChanged         : ClassVar[Signal] = ... # dataProxyChanged(QBarDataProxy*)
    meshAngleChanged         : ClassVar[Signal] = ... # meshAngleChanged(float)
    rowColorsChanged         : ClassVar[Signal] = ... # rowColorsChanged(QList<QColor>)
    selectedBarChanged       : ClassVar[Signal] = ... # selectedBarChanged(QPoint)

    @overload
    def __init__(self, dataProxy: PySide6.QtGraphs.QBarDataProxy, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def dataProxy(self) -> PySide6.QtGraphs.QBarDataProxy: ...
    @staticmethod
    def invalidSelectionPosition() -> PySide6.QtCore.QPoint: ...
    def meshAngle(self) -> float: ...
    def rowColors(self) -> List[PySide6.QtGui.QColor]: ...
    def selectedBar(self) -> PySide6.QtCore.QPoint: ...
    def setDataProxy(self, proxy: PySide6.QtGraphs.QBarDataProxy) -> None: ...
    def setMeshAngle(self, angle: float) -> None: ...
    def setRowColors(self, colors: Sequence[PySide6.QtGui.QColor]) -> None: ...
    def setSelectedBar(self, position: PySide6.QtCore.QPoint) -> None: ...


class QBarCategoryAxis(PySide6.QtGraphs.QAbstractAxis):

    categoriesChanged        : ClassVar[Signal] = ... # categoriesChanged()
    countChanged             : ClassVar[Signal] = ... # countChanged()
    maxChanged               : ClassVar[Signal] = ... # maxChanged(QString)
    minChanged               : ClassVar[Signal] = ... # minChanged(QString)
    rangeChanged             : ClassVar[Signal] = ... # rangeChanged(QString,QString)

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    @overload
    def append(self, categories: Sequence[str]) -> None: ...
    @overload
    def append(self, category: str) -> None: ...
    def at(self, index: int) -> str: ...
    def categories(self) -> List[str]: ...
    def clear(self) -> None: ...
    def count(self) -> int: ...
    def insert(self, index: int, category: str) -> None: ...
    def max(self) -> str: ...
    def min(self) -> str: ...
    def remove(self, category: str) -> None: ...
    def replace(self, oldCategory: str, newCategory: str) -> None: ...
    def setCategories(self, categories: Sequence[str]) -> None: ...
    def setMax(self, maxCategory: str) -> None: ...
    def setMin(self, minCategory: str) -> None: ...
    def setRange(self, minCategory: str, maxCategory: str) -> None: ...
    def type(self) -> PySide6.QtGraphs.QAbstractAxis.AxisType: ...


class QBarDataItem(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QBarDataItem: PySide6.QtGraphs.QBarDataItem) -> None: ...
    @overload
    def __init__(self, value: float) -> None: ...
    @overload
    def __init__(self, value: float, angle: float) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def rotation(self) -> float: ...
    def setRotation(self, angle: float) -> None: ...
    def setValue(self, val: float) -> None: ...
    def value(self) -> float: ...


class QBarDataProxy(PySide6.QtGraphs.QAbstractDataProxy):

    arrayReset               : ClassVar[Signal] = ... # arrayReset()
    colCountChanged          : ClassVar[Signal] = ... # colCountChanged(int)
    columnLabelsChanged      : ClassVar[Signal] = ... # columnLabelsChanged()
    itemChanged              : ClassVar[Signal] = ... # itemChanged(int,int)
    rowCountChanged          : ClassVar[Signal] = ... # rowCountChanged(int)
    rowLabelsChanged         : ClassVar[Signal] = ... # rowLabelsChanged()
    rowsAdded                : ClassVar[Signal] = ... # rowsAdded(int,int)
    rowsChanged              : ClassVar[Signal] = ... # rowsChanged(int,int)
    rowsInserted             : ClassVar[Signal] = ... # rowsInserted(int,int)
    rowsRemoved              : ClassVar[Signal] = ... # rowsRemoved(int,int)
    seriesChanged            : ClassVar[Signal] = ... # seriesChanged(QBar3DSeries*)

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    @overload
    def addRow(self, row: Sequence[PySide6.QtGraphs.QBarDataItem]) -> int: ...
    @overload
    def addRow(self, row: Sequence[PySide6.QtGraphs.QBarDataItem], label: str) -> int: ...
    @overload
    def addRows(self, rows: Sequence[Sequence[PySide6.QtGraphs.QBarDataItem]]) -> int: ...
    @overload
    def addRows(self, rows: Sequence[Sequence[PySide6.QtGraphs.QBarDataItem]], labels: Sequence[str]) -> int: ...
    def array(self) -> List[List[PySide6.QtGraphs.QBarDataItem]]: ...
    def colCount(self) -> int: ...
    def columnLabels(self) -> List[str]: ...
    @overload
    def insertRow(self, rowIndex: int, row: Sequence[PySide6.QtGraphs.QBarDataItem]) -> None: ...
    @overload
    def insertRow(self, rowIndex: int, row: Sequence[PySide6.QtGraphs.QBarDataItem], label: str) -> None: ...
    @overload
    def insertRows(self, rowIndex: int, rows: Sequence[Sequence[PySide6.QtGraphs.QBarDataItem]]) -> None: ...
    @overload
    def insertRows(self, rowIndex: int, rows: Sequence[Sequence[PySide6.QtGraphs.QBarDataItem]], labels: Sequence[str]) -> None: ...
    @overload
    def itemAt(self, position: PySide6.QtCore.QPoint) -> PySide6.QtGraphs.QBarDataItem: ...
    @overload
    def itemAt(self, rowIndex: int, columnIndex: int) -> PySide6.QtGraphs.QBarDataItem: ...
    def removeRows(self, rowIndex: int, removeCount: int, removeLabels: bool = ...) -> None: ...
    @overload
    def resetArray(self) -> None: ...
    @overload
    def resetArray(self, newArray: Sequence[Sequence[PySide6.QtGraphs.QBarDataItem]]) -> None: ...
    @overload
    def resetArray(self, newArray: Sequence[Sequence[PySide6.QtGraphs.QBarDataItem]], rowLabels: Sequence[str], columnLabels: Sequence[str]) -> None: ...
    def rowAt(self, rowIndex: int) -> List[PySide6.QtGraphs.QBarDataItem]: ...
    def rowCount(self) -> int: ...
    def rowLabels(self) -> List[str]: ...
    def series(self) -> PySide6.QtGraphs.QBar3DSeries: ...
    def setColumnLabels(self, labels: Sequence[str]) -> None: ...
    @overload
    def setItem(self, position: PySide6.QtCore.QPoint, item: PySide6.QtGraphs.QBarDataItem) -> None: ...
    @overload
    def setItem(self, rowIndex: int, columnIndex: int, item: PySide6.QtGraphs.QBarDataItem) -> None: ...
    @overload
    def setRow(self, rowIndex: int, row: Sequence[PySide6.QtGraphs.QBarDataItem]) -> None: ...
    @overload
    def setRow(self, rowIndex: int, row: Sequence[PySide6.QtGraphs.QBarDataItem], label: str) -> None: ...
    def setRowLabels(self, labels: Sequence[str]) -> None: ...
    @overload
    def setRows(self, rowIndex: int, rows: Sequence[Sequence[PySide6.QtGraphs.QBarDataItem]]) -> None: ...
    @overload
    def setRows(self, rowIndex: int, rows: Sequence[Sequence[PySide6.QtGraphs.QBarDataItem]], labels: Sequence[str]) -> None: ...


class QBarSeries(PySide6.QtGraphs.QAbstractBarSeries):

    axisXChanged             : ClassVar[Signal] = ... # axisXChanged(QAbstractAxis*)
    axisYChanged             : ClassVar[Signal] = ... # axisYChanged(QAbstractAxis*)

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def axisX(self) -> PySide6.QtGraphs.QAbstractAxis: ...
    def axisY(self) -> PySide6.QtGraphs.QAbstractAxis: ...
    def setAxisX(self, axis: PySide6.QtGraphs.QAbstractAxis) -> None: ...
    def setAxisY(self, axis: PySide6.QtGraphs.QAbstractAxis) -> None: ...
    def type(self) -> PySide6.QtGraphs.QAbstractSeries.SeriesType: ...


class QBarSet(PySide6.QtCore.QObject):

    borderColorChanged       : ClassVar[Signal] = ... # borderColorChanged(QColor)
    borderWidthChanged       : ClassVar[Signal] = ... # borderWidthChanged(double)
    colorChanged             : ClassVar[Signal] = ... # colorChanged(QColor)
    countChanged             : ClassVar[Signal] = ... # countChanged()
    labelChanged             : ClassVar[Signal] = ... # labelChanged()
    labelColorChanged        : ClassVar[Signal] = ... # labelColorChanged(QColor)
    selectedBarsChanged      : ClassVar[Signal] = ... # selectedBarsChanged(QList<int>)
    selectedColorChanged     : ClassVar[Signal] = ... # selectedColorChanged(QColor)
    update                   : ClassVar[Signal] = ... # update()
    valueChanged             : ClassVar[Signal] = ... # valueChanged(int)
    valuesAdded              : ClassVar[Signal] = ... # valuesAdded(int,int)
    valuesChanged            : ClassVar[Signal] = ... # valuesChanged()
    valuesRemoved            : ClassVar[Signal] = ... # valuesRemoved(int,int)

    @overload
    def __init__(self, label: str, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def __lshift__(self, value: float) -> PySide6.QtGraphs.QBarSet: ...
    @overload
    def append(self, value: float) -> None: ...
    @overload
    def append(self, values: Sequence[float]) -> None: ...
    def at(self, index: int) -> float: ...
    def borderColor(self) -> PySide6.QtGui.QColor: ...
    def borderWidth(self) -> float: ...
    def color(self) -> PySide6.QtGui.QColor: ...
    def count(self) -> int: ...
    def deselectAllBars(self) -> None: ...
    def deselectBar(self, index: int) -> None: ...
    def deselectBars(self, indexes: Sequence[int]) -> None: ...
    def insert(self, index: int, value: float) -> None: ...
    def isBarSelected(self, index: int) -> bool: ...
    def label(self) -> str: ...
    def labelColor(self) -> PySide6.QtGui.QColor: ...
    def remove(self, index: int, count: int = ...) -> None: ...
    def replace(self, index: int, value: float) -> None: ...
    def selectAllBars(self) -> None: ...
    def selectBar(self, index: int) -> None: ...
    def selectBars(self, indexes: Sequence[int]) -> None: ...
    def selectedBars(self) -> List[int]: ...
    def selectedColor(self) -> PySide6.QtGui.QColor: ...
    def setBarSelected(self, index: int, selected: bool) -> None: ...
    def setBorderColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setBorderWidth(self, borderWidth: float) -> None: ...
    def setColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setLabel(self, label: str) -> None: ...
    def setLabelColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setSelectedColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setValues(self, values: Sequence[Any]) -> None: ...
    def sum(self) -> float: ...
    def toggleSelection(self, indexes: Sequence[int]) -> None: ...
    def values(self) -> List[Any]: ...


class QCategory3DAxis(PySide6.QtGraphs.QAbstract3DAxis):

    columnLabelsChanged      : ClassVar[Signal] = ... # columnLabelsChanged()
    rowLabelsChanged         : ClassVar[Signal] = ... # rowLabelsChanged()

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def labels(self) -> List[str]: ...
    def setLabels(self, labels: Sequence[str]) -> None: ...


class QCustom3DItem(PySide6.QtCore.QObject):

    meshFileChanged          : ClassVar[Signal] = ... # meshFileChanged(QString)
    needUpdate               : ClassVar[Signal] = ... # needUpdate()
    positionAbsoluteChanged  : ClassVar[Signal] = ... # positionAbsoluteChanged(bool)
    positionChanged          : ClassVar[Signal] = ... # positionChanged(QVector3D)
    rotationChanged          : ClassVar[Signal] = ... # rotationChanged(QQuaternion)
    scalingAbsoluteChanged   : ClassVar[Signal] = ... # scalingAbsoluteChanged(bool)
    scalingChanged           : ClassVar[Signal] = ... # scalingChanged(QVector3D)
    shadowCastingChanged     : ClassVar[Signal] = ... # shadowCastingChanged(bool)
    textureFileChanged       : ClassVar[Signal] = ... # textureFileChanged(QString)
    visibleChanged           : ClassVar[Signal] = ... # visibleChanged(bool)

    @overload
    def __init__(self, meshFile: str, position: PySide6.QtGui.QVector3D, scaling: PySide6.QtGui.QVector3D, rotation: PySide6.QtGui.QQuaternion, texture: PySide6.QtGui.QImage, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def isPositionAbsolute(self) -> bool: ...
    def isScalingAbsolute(self) -> bool: ...
    def isShadowCasting(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def meshFile(self) -> str: ...
    def position(self) -> PySide6.QtGui.QVector3D: ...
    def rotation(self) -> PySide6.QtGui.QQuaternion: ...
    def scaling(self) -> PySide6.QtGui.QVector3D: ...
    def setMeshFile(self, meshFile: str) -> None: ...
    def setPosition(self, position: PySide6.QtGui.QVector3D) -> None: ...
    def setPositionAbsolute(self, positionAbsolute: bool) -> None: ...
    def setRotation(self, rotation: PySide6.QtGui.QQuaternion) -> None: ...
    def setRotationAxisAndAngle(self, axis: PySide6.QtGui.QVector3D, angle: float) -> None: ...
    def setScaling(self, scaling: PySide6.QtGui.QVector3D) -> None: ...
    def setScalingAbsolute(self, scalingAbsolute: bool) -> None: ...
    def setShadowCasting(self, enabled: bool) -> None: ...
    def setTextureFile(self, textureFile: str) -> None: ...
    def setTextureImage(self, textureImage: PySide6.QtGui.QImage) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def textureFile(self) -> str: ...


class QCustom3DLabel(PySide6.QtGraphs.QCustom3DItem):

    backgroundColorChanged   : ClassVar[Signal] = ... # backgroundColorChanged(QColor)
    backgroundEnabledChanged : ClassVar[Signal] = ... # backgroundEnabledChanged(bool)
    borderEnabledChanged     : ClassVar[Signal] = ... # borderEnabledChanged(bool)
    facingCameraChanged      : ClassVar[Signal] = ... # facingCameraChanged(bool)
    fontChanged              : ClassVar[Signal] = ... # fontChanged(QFont)
    textChanged              : ClassVar[Signal] = ... # textChanged(QString)
    textColorChanged         : ClassVar[Signal] = ... # textColorChanged(QColor)

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, text: str, font: Union[PySide6.QtGui.QFont, str, Sequence[str]], position: PySide6.QtGui.QVector3D, scaling: PySide6.QtGui.QVector3D, rotation: PySide6.QtGui.QQuaternion, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def backgroundColor(self) -> PySide6.QtGui.QColor: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def isBackgroundEnabled(self) -> bool: ...
    def isBorderEnabled(self) -> bool: ...
    def isFacingCamera(self) -> bool: ...
    def setBackgroundColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setBackgroundEnabled(self, enabled: bool) -> None: ...
    def setBorderEnabled(self, enabled: bool) -> None: ...
    def setFacingCamera(self, enabled: bool) -> None: ...
    def setFont(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def setText(self, text: str) -> None: ...
    def setTextColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def text(self) -> str: ...
    def textColor(self) -> PySide6.QtGui.QColor: ...


class QCustom3DVolume(PySide6.QtGraphs.QCustom3DItem):

    alphaMultiplierChanged   : ClassVar[Signal] = ... # alphaMultiplierChanged(float)
    colorTableChanged        : ClassVar[Signal] = ... # colorTableChanged()
    drawSliceFramesChanged   : ClassVar[Signal] = ... # drawSliceFramesChanged(bool)
    drawSlicesChanged        : ClassVar[Signal] = ... # drawSlicesChanged(bool)
    preserveOpacityChanged   : ClassVar[Signal] = ... # preserveOpacityChanged(bool)
    sliceFrameColorChanged   : ClassVar[Signal] = ... # sliceFrameColorChanged(QColor)
    sliceFrameGapsChanged    : ClassVar[Signal] = ... # sliceFrameGapsChanged(QVector3D)
    sliceFrameThicknessesChanged: ClassVar[Signal] = ... # sliceFrameThicknessesChanged(QVector3D)
    sliceFrameWidthsChanged  : ClassVar[Signal] = ... # sliceFrameWidthsChanged(QVector3D)
    sliceIndexXChanged       : ClassVar[Signal] = ... # sliceIndexXChanged(int)
    sliceIndexYChanged       : ClassVar[Signal] = ... # sliceIndexYChanged(int)
    sliceIndexZChanged       : ClassVar[Signal] = ... # sliceIndexZChanged(int)
    textureDataChanged       : ClassVar[Signal] = ... # textureDataChanged(QList<uchar>*)
    textureDepthChanged      : ClassVar[Signal] = ... # textureDepthChanged(int)
    textureFormatChanged     : ClassVar[Signal] = ... # textureFormatChanged(QImage::Format)
    textureHeightChanged     : ClassVar[Signal] = ... # textureHeightChanged(int)
    textureWidthChanged      : ClassVar[Signal] = ... # textureWidthChanged(int)
    useHighDefShaderChanged  : ClassVar[Signal] = ... # useHighDefShaderChanged(bool)

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, position: PySide6.QtGui.QVector3D, scaling: PySide6.QtGui.QVector3D, rotation: PySide6.QtGui.QQuaternion, textureWidth: int, textureHeight: int, textureDepth: int, textureData: Sequence[int], textureFormat: PySide6.QtGui.QImage.Format, colorTable: Sequence[int], parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def alphaMultiplier(self) -> float: ...
    def colorTable(self) -> List[int]: ...
    def createTextureData(self, images: Sequence[PySide6.QtGui.QImage]) -> List[int]: ...
    def drawSliceFrames(self) -> bool: ...
    def drawSlices(self) -> bool: ...
    def preserveOpacity(self) -> bool: ...
    def renderSlice(self, axis: PySide6.QtCore.Qt.Axis, index: int) -> PySide6.QtGui.QImage: ...
    def setAlphaMultiplier(self, mult: float) -> None: ...
    def setColorTable(self, colors: Sequence[int]) -> None: ...
    def setDrawSliceFrames(self, enable: bool) -> None: ...
    def setDrawSlices(self, enable: bool) -> None: ...
    def setPreserveOpacity(self, enable: bool) -> None: ...
    def setSliceFrameColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setSliceFrameGaps(self, values: PySide6.QtGui.QVector3D) -> None: ...
    def setSliceFrameThicknesses(self, values: PySide6.QtGui.QVector3D) -> None: ...
    def setSliceFrameWidths(self, values: PySide6.QtGui.QVector3D) -> None: ...
    def setSliceIndexX(self, value: int) -> None: ...
    def setSliceIndexY(self, value: int) -> None: ...
    def setSliceIndexZ(self, value: int) -> None: ...
    def setSliceIndices(self, x: int, y: int, z: int) -> None: ...
    @overload
    def setSubTextureData(self, axis: PySide6.QtCore.Qt.Axis, index: int, data: Union[bytes, bytearray, memoryview]) -> None: ...
    @overload
    def setSubTextureData(self, axis: PySide6.QtCore.Qt.Axis, index: int, image: PySide6.QtGui.QImage) -> None: ...
    def setTextureData(self, arg__1: Sequence[int]) -> None: ...
    def setTextureDepth(self, value: int) -> None: ...
    def setTextureDimensions(self, width: int, height: int, depth: int) -> None: ...
    def setTextureFormat(self, format: PySide6.QtGui.QImage.Format) -> None: ...
    def setTextureHeight(self, value: int) -> None: ...
    def setTextureWidth(self, value: int) -> None: ...
    def setUseHighDefShader(self, enable: bool) -> None: ...
    def sliceFrameColor(self) -> PySide6.QtGui.QColor: ...
    def sliceFrameGaps(self) -> PySide6.QtGui.QVector3D: ...
    def sliceFrameThicknesses(self) -> PySide6.QtGui.QVector3D: ...
    def sliceFrameWidths(self) -> PySide6.QtGui.QVector3D: ...
    def sliceIndexX(self) -> int: ...
    def sliceIndexY(self) -> int: ...
    def sliceIndexZ(self) -> int: ...
    def textureData(self) -> List[int]: ...
    def textureDataWidth(self) -> int: ...
    def textureDepth(self) -> int: ...
    def textureFormat(self) -> PySide6.QtGui.QImage.Format: ...
    def textureHeight(self) -> int: ...
    def textureWidth(self) -> int: ...
    def useHighDefShader(self) -> bool: ...


class QGraphTheme(PySide6.QtCore.QObject, PySide6.QtQml.QQmlParserStatus):

    axisXLabelsColorChanged  : ClassVar[Signal] = ... # axisXLabelsColorChanged()
    axisXLabelsFontChanged   : ClassVar[Signal] = ... # axisXLabelsFontChanged()
    axisXMajorBarWidthChanged: ClassVar[Signal] = ... # axisXMajorBarWidthChanged()
    axisXMajorColorChanged   : ClassVar[Signal] = ... # axisXMajorColorChanged()
    axisXMinorBarWidthChanged: ClassVar[Signal] = ... # axisXMinorBarWidthChanged()
    axisXMinorColorChanged   : ClassVar[Signal] = ... # axisXMinorColorChanged()
    axisXSmoothingChanged    : ClassVar[Signal] = ... # axisXSmoothingChanged()
    axisYLabelsColorChanged  : ClassVar[Signal] = ... # axisYLabelsColorChanged()
    axisYLabelsFontChanged   : ClassVar[Signal] = ... # axisYLabelsFontChanged()
    axisYMajorBarWidthChanged: ClassVar[Signal] = ... # axisYMajorBarWidthChanged()
    axisYMajorColorChanged   : ClassVar[Signal] = ... # axisYMajorColorChanged()
    axisYMinorBarWidthChanged: ClassVar[Signal] = ... # axisYMinorBarWidthChanged()
    axisYMinorColorChanged   : ClassVar[Signal] = ... # axisYMinorColorChanged()
    axisYSmoothingChanged    : ClassVar[Signal] = ... # axisYSmoothingChanged()
    colorThemeChanged        : ClassVar[Signal] = ... # colorThemeChanged()
    gridMajorBarsColorChanged: ClassVar[Signal] = ... # gridMajorBarsColorChanged()
    gridMajorBarsWidthChanged: ClassVar[Signal] = ... # gridMajorBarsWidthChanged()
    gridMinorBarsColorChanged: ClassVar[Signal] = ... # gridMinorBarsColorChanged()
    gridMinorBarsWidthChanged: ClassVar[Signal] = ... # gridMinorBarsWidthChanged()
    gridSmoothingChanged     : ClassVar[Signal] = ... # gridSmoothingChanged()
    shadowBarWidthChanged    : ClassVar[Signal] = ... # shadowBarWidthChanged()
    shadowColorChanged       : ClassVar[Signal] = ... # shadowColorChanged()
    shadowEnabledChanged     : ClassVar[Signal] = ... # shadowEnabledChanged()
    shadowSmoothingChanged   : ClassVar[Signal] = ... # shadowSmoothingChanged()
    shadowXOffsetChanged     : ClassVar[Signal] = ... # shadowXOffsetChanged()
    shadowYOffsetChanged     : ClassVar[Signal] = ... # shadowYOffsetChanged()
    update                   : ClassVar[Signal] = ... # update()

    class ColorTheme(enum.Enum):

        ColorThemeLight          : QGraphTheme.ColorTheme = ... # 0x0
        ColorThemeDark           : QGraphTheme.ColorTheme = ... # 0x1


    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def axisXLabelsColor(self) -> PySide6.QtGui.QColor: ...
    def axisXLabelsFont(self) -> PySide6.QtGui.QFont: ...
    def axisXMajorBarWidth(self) -> float: ...
    def axisXMajorColor(self) -> PySide6.QtGui.QColor: ...
    def axisXMinorBarWidth(self) -> float: ...
    def axisXMinorColor(self) -> PySide6.QtGui.QColor: ...
    def axisXSmoothing(self) -> float: ...
    def axisYLabelsColor(self) -> PySide6.QtGui.QColor: ...
    def axisYLabelsFont(self) -> PySide6.QtGui.QFont: ...
    def axisYMajorBarWidth(self) -> float: ...
    def axisYMajorColor(self) -> PySide6.QtGui.QColor: ...
    def axisYMinorBarWidth(self) -> float: ...
    def axisYMinorColor(self) -> PySide6.QtGui.QColor: ...
    def axisYSmoothing(self) -> float: ...
    def classBegin(self) -> None: ...
    def colorTheme(self) -> PySide6.QtGraphs.QGraphTheme.ColorTheme: ...
    def componentComplete(self) -> None: ...
    def gridMajorBarsColor(self) -> PySide6.QtGui.QColor: ...
    def gridMajorBarsWidth(self) -> float: ...
    def gridMinorBarsColor(self) -> PySide6.QtGui.QColor: ...
    def gridMinorBarsWidth(self) -> float: ...
    def gridSmoothing(self) -> float: ...
    def resetColorTheme(self) -> None: ...
    def resetThemeDirty(self) -> None: ...
    def setAxisXLabelsColor(self, newAxisXLabelsColor: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setAxisXLabelsFont(self, newAxisXLabelsFont: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def setAxisXMajorBarWidth(self, newAxisXMajorBarWidth: float) -> None: ...
    def setAxisXMajorColor(self, newAxisXMajorColor: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setAxisXMinorBarWidth(self, newAxisXMinorBarWidth: float) -> None: ...
    def setAxisXMinorColor(self, newAxisXMinorColor: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setAxisXSmoothing(self, newAxisXSmoothing: float) -> None: ...
    def setAxisYLabelsColor(self, newAxisYLabelsColor: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setAxisYLabelsFont(self, newAxisYLabelsFont: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def setAxisYMajorBarWidth(self, newAxisYMajorBarWidth: float) -> None: ...
    def setAxisYMajorColor(self, newAxisYMajorColor: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setAxisYMinorBarWidth(self, newAxisYMinorBarWidth: float) -> None: ...
    def setAxisYMinorColor(self, newAxisYMinorColor: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setAxisYSmoothing(self, newAxisYSmoothing: float) -> None: ...
    def setColorTheme(self, newColorTheme: PySide6.QtGraphs.QGraphTheme.ColorTheme) -> None: ...
    def setGridMajorBarsColor(self, newGridMajorBarsColor: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setGridMajorBarsWidth(self, newGridMajorBarsWidth: float) -> None: ...
    def setGridMinorBarsColor(self, newGridMinorBarsColor: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setGridMinorBarsWidth(self, newGridMinorBarsWidth: float) -> None: ...
    def setGridSmoothing(self, newGridSmoothing: float) -> None: ...
    def setShadowBarWidth(self, newShadowBarWidth: float) -> None: ...
    def setShadowColor(self, newShadowColor: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setShadowEnabled(self, newShadowEnabled: bool) -> None: ...
    def setShadowSmoothing(self, newShadowSmoothing: float) -> None: ...
    def setShadowXOffset(self, newShadowXOffset: float) -> None: ...
    def setShadowYOffset(self, newShadowYOffset: float) -> None: ...
    def shadowBarWidth(self) -> float: ...
    def shadowColor(self) -> PySide6.QtGui.QColor: ...
    def shadowEnabled(self) -> bool: ...
    def shadowSmoothing(self) -> float: ...
    def shadowXOffset(self) -> float: ...
    def shadowYOffset(self) -> float: ...
    def themeDirty(self) -> bool: ...


class QHeightMapSurfaceDataProxy(PySide6.QtGraphs.QSurfaceDataProxy):

    autoScaleYChanged        : ClassVar[Signal] = ... # autoScaleYChanged(bool)
    heightMapChanged         : ClassVar[Signal] = ... # heightMapChanged(QImage)
    heightMapFileChanged     : ClassVar[Signal] = ... # heightMapFileChanged(QString)
    maxXValueChanged         : ClassVar[Signal] = ... # maxXValueChanged(float)
    maxYValueChanged         : ClassVar[Signal] = ... # maxYValueChanged(float)
    maxZValueChanged         : ClassVar[Signal] = ... # maxZValueChanged(float)
    minXValueChanged         : ClassVar[Signal] = ... # minXValueChanged(float)
    minYValueChanged         : ClassVar[Signal] = ... # minYValueChanged(float)
    minZValueChanged         : ClassVar[Signal] = ... # minZValueChanged(float)

    @overload
    def __init__(self, filename: str, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, image: PySide6.QtGui.QImage, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def autoScaleY(self) -> bool: ...
    def handlePendingResolve(self) -> None: ...
    def heightMap(self) -> PySide6.QtGui.QImage: ...
    def heightMapFile(self) -> str: ...
    def maxXValue(self) -> float: ...
    def maxYValue(self) -> float: ...
    def maxZValue(self) -> float: ...
    def minXValue(self) -> float: ...
    def minYValue(self) -> float: ...
    def minZValue(self) -> float: ...
    def setAutoScaleY(self, enabled: bool) -> None: ...
    def setHeightMap(self, image: PySide6.QtGui.QImage) -> None: ...
    def setHeightMapFile(self, filename: str) -> None: ...
    def setMaxXValue(self, max: float) -> None: ...
    def setMaxYValue(self, max: float) -> None: ...
    def setMaxZValue(self, max: float) -> None: ...
    def setMinXValue(self, min: float) -> None: ...
    def setMinYValue(self, min: float) -> None: ...
    def setMinZValue(self, min: float) -> None: ...
    def setValueRanges(self, minX: float, maxX: float, minZ: float, maxZ: float) -> None: ...


class QIntList(object): ...


class QItemModelBarDataProxy(PySide6.QtGraphs.QBarDataProxy):

    autoColumnCategoriesChanged: ClassVar[Signal] = ... # autoColumnCategoriesChanged(bool)
    autoRowCategoriesChanged : ClassVar[Signal] = ... # autoRowCategoriesChanged(bool)
    columnCategoriesChanged  : ClassVar[Signal] = ... # columnCategoriesChanged()
    columnRoleChanged        : ClassVar[Signal] = ... # columnRoleChanged(QString)
    columnRolePatternChanged : ClassVar[Signal] = ... # columnRolePatternChanged(QRegularExpression)
    columnRoleReplaceChanged : ClassVar[Signal] = ... # columnRoleReplaceChanged(QString)
    itemModelChanged         : ClassVar[Signal] = ... # itemModelChanged(const QAbstractItemModel*)
    multiMatchBehaviorChanged: ClassVar[Signal] = ... # multiMatchBehaviorChanged(QItemModelBarDataProxy::MultiMatchBehavior)
    rotationRoleChanged      : ClassVar[Signal] = ... # rotationRoleChanged(QString)
    rotationRolePatternChanged: ClassVar[Signal] = ... # rotationRolePatternChanged(QRegularExpression)
    rotationRoleReplaceChanged: ClassVar[Signal] = ... # rotationRoleReplaceChanged(QString)
    rowCategoriesChanged     : ClassVar[Signal] = ... # rowCategoriesChanged()
    rowRoleChanged           : ClassVar[Signal] = ... # rowRoleChanged(QString)
    rowRolePatternChanged    : ClassVar[Signal] = ... # rowRolePatternChanged(QRegularExpression)
    rowRoleReplaceChanged    : ClassVar[Signal] = ... # rowRoleReplaceChanged(QString)
    useModelCategoriesChanged: ClassVar[Signal] = ... # useModelCategoriesChanged(bool)
    valueRoleChanged         : ClassVar[Signal] = ... # valueRoleChanged(QString)
    valueRolePatternChanged  : ClassVar[Signal] = ... # valueRolePatternChanged(QRegularExpression)
    valueRoleReplaceChanged  : ClassVar[Signal] = ... # valueRoleReplaceChanged(QString)

    class MultiMatchBehavior(enum.Enum):

        First                    : QItemModelBarDataProxy.MultiMatchBehavior = ... # 0x0
        Last                     : QItemModelBarDataProxy.MultiMatchBehavior = ... # 0x1
        Average                  : QItemModelBarDataProxy.MultiMatchBehavior = ... # 0x2
        Cumulative               : QItemModelBarDataProxy.MultiMatchBehavior = ... # 0x3


    @overload
    def __init__(self, itemModel: PySide6.QtCore.QAbstractItemModel, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, itemModel: PySide6.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, valueRole: str, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, itemModel: PySide6.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, valueRole: str, rotationRole: str, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, itemModel: PySide6.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, valueRole: str, rotationRole: str, rowCategories: Sequence[str], columnCategories: Sequence[str], parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, itemModel: PySide6.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, valueRole: str, rowCategories: Sequence[str], columnCategories: Sequence[str], parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, itemModel: PySide6.QtCore.QAbstractItemModel, valueRole: str, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def autoColumnCategories(self) -> bool: ...
    def autoRowCategories(self) -> bool: ...
    def columnCategories(self) -> List[str]: ...
    def columnCategoryIndex(self, category: str) -> int: ...
    def columnRole(self) -> str: ...
    def columnRolePattern(self) -> PySide6.QtCore.QRegularExpression: ...
    def columnRoleReplace(self) -> str: ...
    def itemModel(self) -> PySide6.QtCore.QAbstractItemModel: ...
    def multiMatchBehavior(self) -> PySide6.QtGraphs.QItemModelBarDataProxy.MultiMatchBehavior: ...
    def remap(self, rowRole: str, columnRole: str, valueRole: str, rotationRole: str, rowCategories: Sequence[str], columnCategories: Sequence[str]) -> None: ...
    def rotationRole(self) -> str: ...
    def rotationRolePattern(self) -> PySide6.QtCore.QRegularExpression: ...
    def rotationRoleReplace(self) -> str: ...
    def rowCategories(self) -> List[str]: ...
    def rowCategoryIndex(self, category: str) -> int: ...
    def rowRole(self) -> str: ...
    def rowRolePattern(self) -> PySide6.QtCore.QRegularExpression: ...
    def rowRoleReplace(self) -> str: ...
    def setAutoColumnCategories(self, enable: bool) -> None: ...
    def setAutoRowCategories(self, enable: bool) -> None: ...
    def setColumnCategories(self, categories: Sequence[str]) -> None: ...
    def setColumnRole(self, role: str) -> None: ...
    def setColumnRolePattern(self, pattern: Union[PySide6.QtCore.QRegularExpression, str]) -> None: ...
    def setColumnRoleReplace(self, replace: str) -> None: ...
    def setItemModel(self, itemModel: PySide6.QtCore.QAbstractItemModel) -> None: ...
    def setMultiMatchBehavior(self, behavior: PySide6.QtGraphs.QItemModelBarDataProxy.MultiMatchBehavior) -> None: ...
    def setRotationRole(self, role: str) -> None: ...
    def setRotationRolePattern(self, pattern: Union[PySide6.QtCore.QRegularExpression, str]) -> None: ...
    def setRotationRoleReplace(self, replace: str) -> None: ...
    def setRowCategories(self, categories: Sequence[str]) -> None: ...
    def setRowRole(self, role: str) -> None: ...
    def setRowRolePattern(self, pattern: Union[PySide6.QtCore.QRegularExpression, str]) -> None: ...
    def setRowRoleReplace(self, replace: str) -> None: ...
    def setUseModelCategories(self, enable: bool) -> None: ...
    def setValueRole(self, role: str) -> None: ...
    def setValueRolePattern(self, pattern: Union[PySide6.QtCore.QRegularExpression, str]) -> None: ...
    def setValueRoleReplace(self, replace: str) -> None: ...
    def useModelCategories(self) -> bool: ...
    def valueRole(self) -> str: ...
    def valueRolePattern(self) -> PySide6.QtCore.QRegularExpression: ...
    def valueRoleReplace(self) -> str: ...


class QItemModelScatterDataProxy(PySide6.QtGraphs.QScatterDataProxy):

    itemModelChanged         : ClassVar[Signal] = ... # itemModelChanged(const QAbstractItemModel*)
    rotationRoleChanged      : ClassVar[Signal] = ... # rotationRoleChanged(QString)
    rotationRolePatternChanged: ClassVar[Signal] = ... # rotationRolePatternChanged(QRegularExpression)
    rotationRoleReplaceChanged: ClassVar[Signal] = ... # rotationRoleReplaceChanged(QString)
    xPosRoleChanged          : ClassVar[Signal] = ... # xPosRoleChanged(QString)
    xPosRolePatternChanged   : ClassVar[Signal] = ... # xPosRolePatternChanged(QRegularExpression)
    xPosRoleReplaceChanged   : ClassVar[Signal] = ... # xPosRoleReplaceChanged(QString)
    yPosRoleChanged          : ClassVar[Signal] = ... # yPosRoleChanged(QString)
    yPosRolePatternChanged   : ClassVar[Signal] = ... # yPosRolePatternChanged(QRegularExpression)
    yPosRoleReplaceChanged   : ClassVar[Signal] = ... # yPosRoleReplaceChanged(QString)
    zPosRoleChanged          : ClassVar[Signal] = ... # zPosRoleChanged(QString)
    zPosRolePatternChanged   : ClassVar[Signal] = ... # zPosRolePatternChanged(QRegularExpression)
    zPosRoleReplaceChanged   : ClassVar[Signal] = ... # zPosRoleReplaceChanged(QString)

    @overload
    def __init__(self, itemModel: PySide6.QtCore.QAbstractItemModel, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, itemModel: PySide6.QtCore.QAbstractItemModel, xPosRole: str, yPosRole: str, zPosRole: str, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, itemModel: PySide6.QtCore.QAbstractItemModel, xPosRole: str, yPosRole: str, zPosRole: str, rotationRole: str, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def itemModel(self) -> PySide6.QtCore.QAbstractItemModel: ...
    def remap(self, xPosRole: str, yPosRole: str, zPosRole: str, rotationRole: str) -> None: ...
    def rotationRole(self) -> str: ...
    def rotationRolePattern(self) -> PySide6.QtCore.QRegularExpression: ...
    def rotationRoleReplace(self) -> str: ...
    def setItemModel(self, itemModel: PySide6.QtCore.QAbstractItemModel) -> None: ...
    def setRotationRole(self, role: str) -> None: ...
    def setRotationRolePattern(self, pattern: Union[PySide6.QtCore.QRegularExpression, str]) -> None: ...
    def setRotationRoleReplace(self, replace: str) -> None: ...
    def setXPosRole(self, role: str) -> None: ...
    def setXPosRolePattern(self, pattern: Union[PySide6.QtCore.QRegularExpression, str]) -> None: ...
    def setXPosRoleReplace(self, replace: str) -> None: ...
    def setYPosRole(self, role: str) -> None: ...
    def setYPosRolePattern(self, pattern: Union[PySide6.QtCore.QRegularExpression, str]) -> None: ...
    def setYPosRoleReplace(self, replace: str) -> None: ...
    def setZPosRole(self, role: str) -> None: ...
    def setZPosRolePattern(self, pattern: Union[PySide6.QtCore.QRegularExpression, str]) -> None: ...
    def setZPosRoleReplace(self, replace: str) -> None: ...
    def xPosRole(self) -> str: ...
    def xPosRolePattern(self) -> PySide6.QtCore.QRegularExpression: ...
    def xPosRoleReplace(self) -> str: ...
    def yPosRole(self) -> str: ...
    def yPosRolePattern(self) -> PySide6.QtCore.QRegularExpression: ...
    def yPosRoleReplace(self) -> str: ...
    def zPosRole(self) -> str: ...
    def zPosRolePattern(self) -> PySide6.QtCore.QRegularExpression: ...
    def zPosRoleReplace(self) -> str: ...


class QItemModelSurfaceDataProxy(PySide6.QtGraphs.QSurfaceDataProxy):

    autoColumnCategoriesChanged: ClassVar[Signal] = ... # autoColumnCategoriesChanged(bool)
    autoRowCategoriesChanged : ClassVar[Signal] = ... # autoRowCategoriesChanged(bool)
    columnCategoriesChanged  : ClassVar[Signal] = ... # columnCategoriesChanged()
    columnRoleChanged        : ClassVar[Signal] = ... # columnRoleChanged(QString)
    columnRolePatternChanged : ClassVar[Signal] = ... # columnRolePatternChanged(QRegularExpression)
    columnRoleReplaceChanged : ClassVar[Signal] = ... # columnRoleReplaceChanged(QString)
    itemModelChanged         : ClassVar[Signal] = ... # itemModelChanged(const QAbstractItemModel*)
    multiMatchBehaviorChanged: ClassVar[Signal] = ... # multiMatchBehaviorChanged(QItemModelSurfaceDataProxy::MultiMatchBehavior)
    rowCategoriesChanged     : ClassVar[Signal] = ... # rowCategoriesChanged()
    rowRoleChanged           : ClassVar[Signal] = ... # rowRoleChanged(QString)
    rowRolePatternChanged    : ClassVar[Signal] = ... # rowRolePatternChanged(QRegularExpression)
    rowRoleReplaceChanged    : ClassVar[Signal] = ... # rowRoleReplaceChanged(QString)
    useModelCategoriesChanged: ClassVar[Signal] = ... # useModelCategoriesChanged(bool)
    xPosRoleChanged          : ClassVar[Signal] = ... # xPosRoleChanged(QString)
    xPosRolePatternChanged   : ClassVar[Signal] = ... # xPosRolePatternChanged(QRegularExpression)
    xPosRoleReplaceChanged   : ClassVar[Signal] = ... # xPosRoleReplaceChanged(QString)
    yPosRoleChanged          : ClassVar[Signal] = ... # yPosRoleChanged(QString)
    yPosRolePatternChanged   : ClassVar[Signal] = ... # yPosRolePatternChanged(QRegularExpression)
    yPosRoleReplaceChanged   : ClassVar[Signal] = ... # yPosRoleReplaceChanged(QString)
    zPosRoleChanged          : ClassVar[Signal] = ... # zPosRoleChanged(QString)
    zPosRolePatternChanged   : ClassVar[Signal] = ... # zPosRolePatternChanged(QRegularExpression)
    zPosRoleReplaceChanged   : ClassVar[Signal] = ... # zPosRoleReplaceChanged(QString)

    class MultiMatchBehavior(enum.Enum):

        First                    : QItemModelSurfaceDataProxy.MultiMatchBehavior = ... # 0x0
        Last                     : QItemModelSurfaceDataProxy.MultiMatchBehavior = ... # 0x1
        Average                  : QItemModelSurfaceDataProxy.MultiMatchBehavior = ... # 0x2
        CumulativeY              : QItemModelSurfaceDataProxy.MultiMatchBehavior = ... # 0x3


    @overload
    def __init__(self, itemModel: PySide6.QtCore.QAbstractItemModel, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, itemModel: PySide6.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, xPosRole: str, yPosRole: str, zPosRole: str, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, itemModel: PySide6.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, xPosRole: str, yPosRole: str, zPosRole: str, rowCategories: Sequence[str], columnCategories: Sequence[str], parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, itemModel: PySide6.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, yPosRole: str, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, itemModel: PySide6.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, yPosRole: str, rowCategories: Sequence[str], columnCategories: Sequence[str], parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, itemModel: PySide6.QtCore.QAbstractItemModel, yPosRole: str, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def autoColumnCategories(self) -> bool: ...
    def autoRowCategories(self) -> bool: ...
    def columnCategories(self) -> List[str]: ...
    def columnCategoryIndex(self, category: str) -> int: ...
    def columnRole(self) -> str: ...
    def columnRolePattern(self) -> PySide6.QtCore.QRegularExpression: ...
    def columnRoleReplace(self) -> str: ...
    def itemModel(self) -> PySide6.QtCore.QAbstractItemModel: ...
    def multiMatchBehavior(self) -> PySide6.QtGraphs.QItemModelSurfaceDataProxy.MultiMatchBehavior: ...
    def remap(self, rowRole: str, columnRole: str, xPosRole: str, yPosRole: str, zPosRole: str, rowCategories: Sequence[str], columnCategories: Sequence[str]) -> None: ...
    def rowCategories(self) -> List[str]: ...
    def rowCategoryIndex(self, category: str) -> int: ...
    def rowRole(self) -> str: ...
    def rowRolePattern(self) -> PySide6.QtCore.QRegularExpression: ...
    def rowRoleReplace(self) -> str: ...
    def setAutoColumnCategories(self, enable: bool) -> None: ...
    def setAutoRowCategories(self, enable: bool) -> None: ...
    def setColumnCategories(self, categories: Sequence[str]) -> None: ...
    def setColumnRole(self, role: str) -> None: ...
    def setColumnRolePattern(self, pattern: Union[PySide6.QtCore.QRegularExpression, str]) -> None: ...
    def setColumnRoleReplace(self, replace: str) -> None: ...
    def setItemModel(self, itemModel: PySide6.QtCore.QAbstractItemModel) -> None: ...
    def setMultiMatchBehavior(self, behavior: PySide6.QtGraphs.QItemModelSurfaceDataProxy.MultiMatchBehavior) -> None: ...
    def setRowCategories(self, categories: Sequence[str]) -> None: ...
    def setRowRole(self, role: str) -> None: ...
    def setRowRolePattern(self, pattern: Union[PySide6.QtCore.QRegularExpression, str]) -> None: ...
    def setRowRoleReplace(self, replace: str) -> None: ...
    def setUseModelCategories(self, enable: bool) -> None: ...
    def setXPosRole(self, role: str) -> None: ...
    def setXPosRolePattern(self, pattern: Union[PySide6.QtCore.QRegularExpression, str]) -> None: ...
    def setXPosRoleReplace(self, replace: str) -> None: ...
    def setYPosRole(self, role: str) -> None: ...
    def setYPosRolePattern(self, pattern: Union[PySide6.QtCore.QRegularExpression, str]) -> None: ...
    def setYPosRoleReplace(self, replace: str) -> None: ...
    def setZPosRole(self, role: str) -> None: ...
    def setZPosRolePattern(self, pattern: Union[PySide6.QtCore.QRegularExpression, str]) -> None: ...
    def setZPosRoleReplace(self, replace: str) -> None: ...
    def useModelCategories(self) -> bool: ...
    def xPosRole(self) -> str: ...
    def xPosRolePattern(self) -> PySide6.QtCore.QRegularExpression: ...
    def xPosRoleReplace(self) -> str: ...
    def yPosRole(self) -> str: ...
    def yPosRolePattern(self) -> PySide6.QtCore.QRegularExpression: ...
    def yPosRoleReplace(self) -> str: ...
    def zPosRole(self) -> str: ...
    def zPosRolePattern(self) -> PySide6.QtCore.QRegularExpression: ...
    def zPosRoleReplace(self) -> str: ...


class QLineSeries(PySide6.QtGraphs.QXYSeries):

    capStyleChanged          : ClassVar[Signal] = ... # capStyleChanged()
    widthChanged             : ClassVar[Signal] = ... # widthChanged()

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def capStyle(self) -> PySide6.QtCore.Qt.PenCapStyle: ...
    def componentComplete(self) -> None: ...
    def setCapStyle(self, newCapStyle: PySide6.QtCore.Qt.PenCapStyle) -> None: ...
    def setWidth(self, newWidth: float) -> None: ...
    def type(self) -> PySide6.QtGraphs.QAbstractSeries.SeriesType: ...
    def width(self) -> float: ...


class QLogValue3DAxisFormatter(PySide6.QtGraphs.QValue3DAxisFormatter):

    autoSubGridChanged       : ClassVar[Signal] = ... # autoSubGridChanged(bool)
    baseChanged              : ClassVar[Signal] = ... # baseChanged(double)
    showEdgeLabelsChanged    : ClassVar[Signal] = ... # showEdgeLabelsChanged(bool)

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def autoSubGrid(self) -> bool: ...
    def base(self) -> float: ...
    def createNewInstance(self) -> PySide6.QtGraphs.QValue3DAxisFormatter: ...
    def populateCopy(self, copy: PySide6.QtGraphs.QValue3DAxisFormatter) -> None: ...
    def positionAt(self, value: float) -> float: ...
    def recalculate(self) -> None: ...
    def setAutoSubGrid(self, enabled: bool) -> None: ...
    def setBase(self, base: float) -> None: ...
    def setShowEdgeLabels(self, enabled: bool) -> None: ...
    def showEdgeLabels(self) -> bool: ...
    def valueAt(self, position: float) -> float: ...


class QPointFList(object): ...


class QScatter3DSeries(PySide6.QtGraphs.QAbstract3DSeries):

    dataProxyChanged         : ClassVar[Signal] = ... # dataProxyChanged(QScatterDataProxy*)
    itemSizeChanged          : ClassVar[Signal] = ... # itemSizeChanged(float)
    selectedItemChanged      : ClassVar[Signal] = ... # selectedItemChanged(int)

    @overload
    def __init__(self, dataProxy: PySide6.QtGraphs.QScatterDataProxy, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def dataProxy(self) -> PySide6.QtGraphs.QScatterDataProxy: ...
    @staticmethod
    def invalidSelectionIndex() -> int: ...
    def itemSize(self) -> float: ...
    def selectedItem(self) -> int: ...
    def setDataProxy(self, proxy: PySide6.QtGraphs.QScatterDataProxy) -> None: ...
    def setItemSize(self, size: float) -> None: ...
    def setSelectedItem(self, index: int) -> None: ...


class QScatterDataItem(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QScatterDataItem: PySide6.QtGraphs.QScatterDataItem) -> None: ...
    @overload
    def __init__(self, position: PySide6.QtGui.QVector3D) -> None: ...
    @overload
    def __init__(self, position: PySide6.QtGui.QVector3D, rotation: PySide6.QtGui.QQuaternion) -> None: ...
    @overload
    def __init__(self, x: float, y: float, z: float) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def position(self) -> PySide6.QtGui.QVector3D: ...
    def rotation(self) -> PySide6.QtGui.QQuaternion: ...
    def setPosition(self, pos: PySide6.QtGui.QVector3D) -> None: ...
    def setRotation(self, rot: PySide6.QtGui.QQuaternion) -> None: ...
    def setX(self, value: float) -> None: ...
    def setY(self, value: float) -> None: ...
    def setZ(self, value: float) -> None: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...


class QScatterDataProxy(PySide6.QtGraphs.QAbstractDataProxy):

    arrayReset               : ClassVar[Signal] = ... # arrayReset()
    itemCountChanged         : ClassVar[Signal] = ... # itemCountChanged(int)
    itemsAdded               : ClassVar[Signal] = ... # itemsAdded(int,int)
    itemsChanged             : ClassVar[Signal] = ... # itemsChanged(int,int)
    itemsInserted            : ClassVar[Signal] = ... # itemsInserted(int,int)
    itemsRemoved             : ClassVar[Signal] = ... # itemsRemoved(int,int)
    seriesChanged            : ClassVar[Signal] = ... # seriesChanged(QScatter3DSeries*)

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def addItem(self, item: PySide6.QtGraphs.QScatterDataItem) -> int: ...
    def addItems(self, items: Sequence[PySide6.QtGraphs.QScatterDataItem]) -> int: ...
    def array(self) -> List[PySide6.QtGraphs.QScatterDataItem]: ...
    def insertItem(self, index: int, item: PySide6.QtGraphs.QScatterDataItem) -> None: ...
    def insertItems(self, index: int, items: Sequence[PySide6.QtGraphs.QScatterDataItem]) -> None: ...
    def itemAt(self, index: int) -> PySide6.QtGraphs.QScatterDataItem: ...
    def itemCount(self) -> int: ...
    def removeItems(self, index: int, removeCount: int) -> None: ...
    @overload
    def resetArray(self) -> None: ...
    @overload
    def resetArray(self, newArray: Sequence[PySide6.QtGraphs.QScatterDataItem]) -> None: ...
    def series(self) -> PySide6.QtGraphs.QScatter3DSeries: ...
    def setItem(self, index: int, item: PySide6.QtGraphs.QScatterDataItem) -> None: ...
    def setItems(self, index: int, items: Sequence[PySide6.QtGraphs.QScatterDataItem]) -> None: ...


class QScatterSeries(PySide6.QtGraphs.QXYSeries):

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def componentComplete(self) -> None: ...
    def type(self) -> PySide6.QtGraphs.QAbstractSeries.SeriesType: ...


class QSeriesTheme(PySide6.QtCore.QObject, PySide6.QtQml.QQmlParserStatus):

    borderColorsChanged      : ClassVar[Signal] = ... # borderColorsChanged()
    borderWidthChanged       : ClassVar[Signal] = ... # borderWidthChanged()
    colorThemeChanged        : ClassVar[Signal] = ... # colorThemeChanged()
    colorsChanged            : ClassVar[Signal] = ... # colorsChanged()
    update                   : ClassVar[Signal] = ... # update()

    class SeriesColorTheme(enum.Enum):

        SeriesTheme1             : QSeriesTheme.SeriesColorTheme = ... # 0x0
        SeriesTheme2             : QSeriesTheme.SeriesColorTheme = ... # 0x1


    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def borderColors(self) -> List[PySide6.QtGui.QColor]: ...
    def borderWidth(self) -> float: ...
    def classBegin(self) -> None: ...
    def colorTheme(self) -> PySide6.QtGraphs.QSeriesTheme.SeriesColorTheme: ...
    def colors(self) -> List[PySide6.QtGui.QColor]: ...
    def componentComplete(self) -> None: ...
    def graphSeriesBorderColor(self, index: int) -> PySide6.QtGui.QColor: ...
    def graphSeriesColor(self, index: int) -> PySide6.QtGui.QColor: ...
    def graphSeriesCount(self) -> int: ...
    def indexColorFrom(self, colors: Sequence[PySide6.QtGui.QColor], index: int) -> PySide6.QtGui.QColor: ...
    def resetColorTheme(self) -> None: ...
    def setBorderColors(self, newBorderColors: Sequence[PySide6.QtGui.QColor]) -> None: ...
    def setBorderWidth(self, newBorderWidth: float) -> None: ...
    def setColorTheme(self, newColorTheme: PySide6.QtGraphs.QSeriesTheme.SeriesColorTheme) -> None: ...
    def setColors(self, newColors: Sequence[PySide6.QtGui.QColor]) -> None: ...
    def setGraphSeriesCount(self, count: int) -> None: ...


class QSurface3DSeries(PySide6.QtGraphs.QAbstract3DSeries):

    dataProxyChanged         : ClassVar[Signal] = ... # dataProxyChanged(QSurfaceDataProxy*)
    drawModeChanged          : ClassVar[Signal] = ... # drawModeChanged(QSurface3DSeries::DrawFlags)
    flatShadingEnabledChanged: ClassVar[Signal] = ... # flatShadingEnabledChanged(bool)
    flatShadingSupportedChanged: ClassVar[Signal] = ... # flatShadingSupportedChanged(bool)
    selectedPointChanged     : ClassVar[Signal] = ... # selectedPointChanged(QPoint)
    textureChanged           : ClassVar[Signal] = ... # textureChanged(QImage)
    textureFileChanged       : ClassVar[Signal] = ... # textureFileChanged(QString)
    wireframeColorChanged    : ClassVar[Signal] = ... # wireframeColorChanged(QColor)

    class DrawFlag(enum.Flag):

        DrawWireframe            : QSurface3DSeries.DrawFlag = ... # 0x1
        DrawSurface              : QSurface3DSeries.DrawFlag = ... # 0x2
        DrawSurfaceAndWireframe  : QSurface3DSeries.DrawFlag = ... # 0x3


    @overload
    def __init__(self, dataProxy: PySide6.QtGraphs.QSurfaceDataProxy, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def dataProxy(self) -> PySide6.QtGraphs.QSurfaceDataProxy: ...
    def drawMode(self) -> PySide6.QtGraphs.QSurface3DSeries.DrawFlag: ...
    @staticmethod
    def invalidSelectionPosition() -> PySide6.QtCore.QPoint: ...
    def isFlatShadingEnabled(self) -> bool: ...
    def isFlatShadingSupported(self) -> bool: ...
    def selectedPoint(self) -> PySide6.QtCore.QPoint: ...
    def setDataProxy(self, proxy: PySide6.QtGraphs.QSurfaceDataProxy) -> None: ...
    def setDrawMode(self, mode: PySide6.QtGraphs.QSurface3DSeries.DrawFlag) -> None: ...
    def setFlatShadingEnabled(self, enabled: bool) -> None: ...
    def setSelectedPoint(self, position: PySide6.QtCore.QPoint) -> None: ...
    def setTexture(self, texture: PySide6.QtGui.QImage) -> None: ...
    def setTextureFile(self, filename: str) -> None: ...
    def setWireframeColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def texture(self) -> PySide6.QtGui.QImage: ...
    def textureFile(self) -> str: ...
    def wireframeColor(self) -> PySide6.QtGui.QColor: ...


class QSurfaceDataItem(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QSurfaceDataItem: PySide6.QtGraphs.QSurfaceDataItem) -> None: ...
    @overload
    def __init__(self, position: PySide6.QtGui.QVector3D) -> None: ...
    @overload
    def __init__(self, x: float, y: float, z: float) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def position(self) -> PySide6.QtGui.QVector3D: ...
    def setPosition(self, pos: PySide6.QtGui.QVector3D) -> None: ...
    def setX(self, value: float) -> None: ...
    def setY(self, value: float) -> None: ...
    def setZ(self, value: float) -> None: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...


class QSurfaceDataProxy(PySide6.QtGraphs.QAbstractDataProxy):

    arrayReset               : ClassVar[Signal] = ... # arrayReset()
    columnCountChanged       : ClassVar[Signal] = ... # columnCountChanged(int)
    itemChanged              : ClassVar[Signal] = ... # itemChanged(int,int)
    rowCountChanged          : ClassVar[Signal] = ... # rowCountChanged(int)
    rowsAdded                : ClassVar[Signal] = ... # rowsAdded(int,int)
    rowsChanged              : ClassVar[Signal] = ... # rowsChanged(int,int)
    rowsInserted             : ClassVar[Signal] = ... # rowsInserted(int,int)
    rowsRemoved              : ClassVar[Signal] = ... # rowsRemoved(int,int)
    seriesChanged            : ClassVar[Signal] = ... # seriesChanged(QSurface3DSeries*)

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def addRow(self, row: Sequence[PySide6.QtGraphs.QSurfaceDataItem]) -> int: ...
    def addRows(self, rows: Sequence[Sequence[PySide6.QtGraphs.QSurfaceDataItem]]) -> int: ...
    def array(self) -> List[List[PySide6.QtGraphs.QSurfaceDataItem]]: ...
    def columnCount(self) -> int: ...
    def insertRow(self, rowIndex: int, row: Sequence[PySide6.QtGraphs.QSurfaceDataItem]) -> None: ...
    def insertRows(self, rowIndex: int, rows: Sequence[Sequence[PySide6.QtGraphs.QSurfaceDataItem]]) -> None: ...
    @overload
    def itemAt(self, position: PySide6.QtCore.QPoint) -> PySide6.QtGraphs.QSurfaceDataItem: ...
    @overload
    def itemAt(self, rowIndex: int, columnIndex: int) -> PySide6.QtGraphs.QSurfaceDataItem: ...
    def removeRows(self, rowIndex: int, removeCount: int) -> None: ...
    @overload
    def resetArray(self) -> None: ...
    @overload
    def resetArray(self, newArray: Sequence[Sequence[PySide6.QtGraphs.QSurfaceDataItem]]) -> None: ...
    def resetArrayNp(self, x: float, deltaX: float, z: float, deltaZ: float, data: shibokensupport.signature.mapping.ArrayLikeVariable) -> None: ...
    def rowCount(self) -> int: ...
    def series(self) -> PySide6.QtGraphs.QSurface3DSeries: ...
    @overload
    def setItem(self, position: PySide6.QtCore.QPoint, item: PySide6.QtGraphs.QSurfaceDataItem) -> None: ...
    @overload
    def setItem(self, rowIndex: int, columnIndex: int, item: PySide6.QtGraphs.QSurfaceDataItem) -> None: ...
    def setRow(self, rowIndex: int, row: Sequence[PySide6.QtGraphs.QSurfaceDataItem]) -> None: ...
    def setRows(self, rowIndex: int, rows: Sequence[Sequence[PySide6.QtGraphs.QSurfaceDataItem]]) -> None: ...


class QTouch3DInputHandler(PySide6.QtGraphs.Q3DInputHandler):

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def touchEvent(self, event: PySide6.QtGui.QTouchEvent) -> None: ...


class QValue3DAxis(PySide6.QtGraphs.QAbstract3DAxis):

    formatterChanged         : ClassVar[Signal] = ... # formatterChanged(QValue3DAxisFormatter*)
    formatterDirty           : ClassVar[Signal] = ... # formatterDirty()
    labelFormatChanged       : ClassVar[Signal] = ... # labelFormatChanged(QString)
    reversedChanged          : ClassVar[Signal] = ... # reversedChanged(bool)
    segmentCountChanged      : ClassVar[Signal] = ... # segmentCountChanged(int)
    subSegmentCountChanged   : ClassVar[Signal] = ... # subSegmentCountChanged(int)

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def formatter(self) -> PySide6.QtGraphs.QValue3DAxisFormatter: ...
    def gridPositionAt(self, gridLine: int) -> float: ...
    def gridSize(self) -> int: ...
    def labelFormat(self) -> str: ...
    def labelPositionAt(self, index: int) -> float: ...
    def positionAt(self, x: float) -> float: ...
    def recalculate(self) -> None: ...
    def reversed(self) -> bool: ...
    def segmentCount(self) -> int: ...
    def setFormatter(self, formatter: PySide6.QtGraphs.QValue3DAxisFormatter) -> None: ...
    def setLabelFormat(self, format: str) -> None: ...
    def setReversed(self, enable: bool) -> None: ...
    def setSegmentCount(self, count: int) -> None: ...
    def setSubSegmentCount(self, count: int) -> None: ...
    def stringForValue(self, x: float) -> str: ...
    def subGridPositionAt(self, gridLine: int) -> float: ...
    def subGridSize(self) -> int: ...
    def subSegmentCount(self) -> int: ...


class QValue3DAxisFormatter(PySide6.QtCore.QObject):

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def allowNegatives(self) -> bool: ...
    def allowZero(self) -> bool: ...
    def axis(self) -> PySide6.QtGraphs.QValue3DAxis: ...
    def createNewInstance(self) -> PySide6.QtGraphs.QValue3DAxisFormatter: ...
    def gridPositions(self) -> List[float]: ...
    def labelPositions(self) -> List[float]: ...
    def labelStrings(self) -> List[str]: ...
    def locale(self) -> PySide6.QtCore.QLocale: ...
    def markDirty(self, labelsChange: bool = ...) -> None: ...
    def populateCopy(self, copy: PySide6.QtGraphs.QValue3DAxisFormatter) -> None: ...
    def positionAt(self, value: float) -> float: ...
    def recalculate(self) -> None: ...
    def setAllowNegatives(self, allow: bool) -> None: ...
    def setAllowZero(self, allow: bool) -> None: ...
    def setAxis(self, axis: PySide6.QtGraphs.QValue3DAxis) -> None: ...
    def setGridPoitions(self, gridPositions: Sequence[float]) -> None: ...
    def setLabelStrings(self, labelStrings: Sequence[str]) -> None: ...
    def setLocale(self, locale: Union[PySide6.QtCore.QLocale, PySide6.QtCore.QLocale.Language]) -> None: ...
    def setSubGridPositions(self, subGridPositions: Sequence[float]) -> None: ...
    def setlabelPositions(self, labelPositions: Sequence[float]) -> None: ...
    def stringForValue(self, value: float, format: str) -> str: ...
    def subGridPositions(self) -> List[float]: ...
    def valueAt(self, position: float) -> float: ...


class QValueAxis(PySide6.QtGraphs.QAbstractAxis):

    labelDecimalsChanged     : ClassVar[Signal] = ... # labelDecimalsChanged(int)
    labelFormatChanged       : ClassVar[Signal] = ... # labelFormatChanged(QString)
    maxChanged               : ClassVar[Signal] = ... # maxChanged(double)
    minChanged               : ClassVar[Signal] = ... # minChanged(double)
    minorTickCountChanged    : ClassVar[Signal] = ... # minorTickCountChanged(int)
    rangeChanged             : ClassVar[Signal] = ... # rangeChanged(double,double)
    tickAnchorChanged        : ClassVar[Signal] = ... # tickAnchorChanged(double)
    tickIntervalChanged      : ClassVar[Signal] = ... # tickIntervalChanged(double)

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def labelDecimals(self) -> int: ...
    def labelFormat(self) -> str: ...
    def max(self) -> float: ...
    def min(self) -> float: ...
    def minorTickCount(self) -> int: ...
    def setLabelDecimals(self, decimals: int) -> None: ...
    def setLabelFormat(self, format: str) -> None: ...
    def setMax(self, max: float) -> None: ...
    def setMin(self, min: float) -> None: ...
    def setMinorTickCount(self, count: int) -> None: ...
    def setRange(self, min: float, max: float) -> None: ...
    def setTickAnchor(self, anchor: float) -> None: ...
    def setTickInterval(self, insterval: float) -> None: ...
    def tickAnchor(self) -> float: ...
    def tickInterval(self) -> float: ...
    def type(self) -> PySide6.QtGraphs.QAbstractAxis.AxisType: ...


class QXYSeries(PySide6.QtGraphs.QAbstractSeries):

    axisXChanged             : ClassVar[Signal] = ... # axisXChanged()
    axisYChanged             : ClassVar[Signal] = ... # axisYChanged()
    colorChanged             : ClassVar[Signal] = ... # colorChanged(QColor)
    markerSizeChanged        : ClassVar[Signal] = ... # markerSizeChanged(double)
    pointAdded               : ClassVar[Signal] = ... # pointAdded(int)
    pointMarkerChanged       : ClassVar[Signal] = ... # pointMarkerChanged()
    pointRemoved             : ClassVar[Signal] = ... # pointRemoved(int)
    pointReplaced            : ClassVar[Signal] = ... # pointReplaced(int)
    pointsRemoved            : ClassVar[Signal] = ... # pointsRemoved(int,int)
    pointsReplaced           : ClassVar[Signal] = ... # pointsReplaced()
    selectedColorChanged     : ClassVar[Signal] = ... # selectedColorChanged(QColor)
    selectedPointsChanged    : ClassVar[Signal] = ... # selectedPointsChanged()
    @overload
    def __lshift__(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtGraphs.QXYSeries: ...
    @overload
    def __lshift__(self, points: Sequence[PySide6.QtCore.QPointF]) -> PySide6.QtGraphs.QXYSeries: ...
    @overload
    def append(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def append(self, points: Sequence[PySide6.QtCore.QPointF]) -> None: ...
    @overload
    def append(self, x: float, y: float) -> None: ...
    def at(self, index: int) -> PySide6.QtCore.QPointF: ...
    def axisX(self) -> PySide6.QtGraphs.QAbstractAxis: ...
    def axisY(self) -> PySide6.QtGraphs.QAbstractAxis: ...
    def clear(self) -> None: ...
    def color(self) -> PySide6.QtGui.QColor: ...
    def count(self) -> int: ...
    def deselectAllPoints(self) -> None: ...
    def deselectPoint(self, index: int) -> None: ...
    def deselectPoints(self, indexes: Sequence[int]) -> None: ...
    def insert(self, index: int, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def isPointSelected(self, index: int) -> bool: ...
    def markerSize(self) -> float: ...
    def pointMarker(self) -> PySide6.QtQml.QQmlComponent: ...
    def points(self) -> List[PySide6.QtCore.QPointF]: ...
    @overload
    def remove(self, index: int) -> None: ...
    @overload
    def remove(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def remove(self, x: float, y: float) -> None: ...
    def removePoints(self, index: int, count: int) -> None: ...
    @overload
    def replace(self, index: int, newPoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def replace(self, index: int, newX: float, newY: float) -> None: ...
    @overload
    def replace(self, oldPoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], newPoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def replace(self, oldX: float, oldY: float, newX: float, newY: float) -> None: ...
    @overload
    def replace(self, points: Sequence[PySide6.QtCore.QPointF]) -> None: ...
    def selectAllPoints(self) -> None: ...
    def selectPoint(self, index: int) -> None: ...
    def selectPoints(self, indexes: Sequence[int]) -> None: ...
    def selectedColor(self) -> PySide6.QtGui.QColor: ...
    def selectedPoints(self) -> List[int]: ...
    def setAxisX(self, axis: PySide6.QtGraphs.QAbstractAxis) -> None: ...
    def setAxisY(self, axis: PySide6.QtGraphs.QAbstractAxis) -> None: ...
    def setColor(self, newColor: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setMarkerSize(self, size: float) -> None: ...
    def setPointMarker(self, newPointMarker: PySide6.QtQml.QQmlComponent) -> None: ...
    def setPointSelected(self, index: int, selected: bool) -> None: ...
    def setSelectedColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def toggleSelection(self, indexes: Sequence[int]) -> None: ...


def qDefaultSurfaceFormat(antialias: bool) -> PySide6.QtGui.QSurfaceFormat: ...


# eof
